/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectDataManager.class.getName()));
    private static final com.intellij.openapi.util.Key<Boolean> DATA_READY = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result2 = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result2.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result2.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result2.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            return result2;
        }
    };

    public static ProjectDataManager getInstance() {
        return (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
    }

    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (project2.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        for (Key key2 : ((Map)this.myServices.getValue()).keySet()) {
            if (grouped.containsKey((Object)key2)) continue;
            grouped.put((Object)key2, Collections.emptyList());
        }
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        try {
            Set entries = grouped.entrySet();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = entries.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Map.Entry entry : entries) {
                if (indicator != null) {
                    String message2 = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManager.getReadableText((Key)entry.getKey())});
                    indicator.setText(message2);
                    indicator.setFraction((double)count++ / (double)size);
                }
                this.doImportData((Key)entry.getKey(), (Collection)entry.getValue(), projectData, project2, modelsProvider, postImportTasks, onSuccessImportTasks);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManager.commit(modelsProvider, project2, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
        }
        catch (Throwable t) {
            ProjectDataManager.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        for (Runnable onSuccessImportTask : ContainerUtil.reverse((List)onSuccessImportTasks)) {
            onSuccessImportTask.run();
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key2) {
        StringBuilder buffer = new StringBuilder();
        String s = key2.toString();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char currChar = s.charAt(i2);
            if (Character.isUpperCase(currChar)) {
                if (i2 != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        return buffer.toString();
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        List dummy = ContainerUtil.newSmartList();
        for (DataNode<T> node : nodes) {
            dummy.add(node);
        }
        this.importData(dummy, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project2, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key2, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks) {
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ProjectImpl) assert (((ProjectImpl)project2).isComponentsCreated());
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key2.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key2);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", toImport, key2, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project2, modelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project2, modelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project2, modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onSuccessImport(project2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode) {
        if (dataNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode.getUserData(DATA_READY))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, dataNode1 -> {
            this.prepareDataToUse((DataNode)dataNode1);
            dataNode1.putUserData(DATA_READY, (Object)Boolean.TRUE);
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key2, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key2);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManager.commit(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManager.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key2, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, boolean synchronous) {
        this.removeData(key2, toRemove, toIgnore, projectData, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (!project2.isDisposed()) {
            ExternalProjectsManager.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (!project2.isDisposed()) {
            return ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
        }
        return ContainerUtil.emptyList();
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private void prepareDataToUse(@NotNull DataNode dataNode) {
        Map servicesByKey = (Map)this.myServices.getValue();
        List services = (List)servicesByKey.get(dataNode.getKey());
        if (services != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, service -> service.getClass().getClassLoader()));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
            }
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous, final @NotNull String commitDesc) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

