/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Tag(value="activation")
public class TaskActivationState {
    @Tag(value="before_run")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRunTasks = new ArrayList<String>();
    @Tag(value="before_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeSyncTasks = new ArrayList<String>();
    @Tag(value="after_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterSyncTasks = new ArrayList<String>();
    @Tag(value="before_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeCompileTasks = new ArrayList<String>();
    @Tag(value="after_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterCompileTasks = new ArrayList<String>();
    @Tag(value="after_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterRebuildTask = new ArrayList<String>();
    @Tag(value="before_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRebuildTask = new ArrayList<String>();

    public boolean isEmpty() {
        for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
            if (this.getTasks(phase).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<String> getTasks(@NotNull ExternalSystemTaskActivator.Phase phase) {
        switch (phase) {
            case AFTER_COMPILE: {
                return this.afterCompileTasks;
            }
            case BEFORE_COMPILE: {
                return this.beforeCompileTasks;
            }
            case AFTER_SYNC: {
                return this.afterSyncTasks;
            }
            case BEFORE_RUN: {
                return this.beforeRunTasks;
            }
            case BEFORE_SYNC: {
                return this.beforeSyncTasks;
            }
            case AFTER_REBUILD: {
                return this.afterRebuildTask;
            }
            case BEFORE_REBUILD: {
                return this.beforeRebuildTask;
            }
        }
        throw new IllegalArgumentException("Unknown task activation phase: " + (Object)((Object)phase));
    }
}

