/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewAdapter;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectExternalSystemNodeDialog
extends DialogWrapper {
    @NotNull
    private final SimpleTree myTree;
    @Nullable
    private final NodeSelector mySelector;
    @Nullable
    protected Boolean groupTasks;
    @Nullable
    protected Boolean useTasksNode;

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId systemId, @NotNull Project project2, @NotNull String title, Class<? extends ExternalSystemNode> nodeClass, @Nullable NodeSelector selector2) {
        this(systemId, project2, title, new Class[]{nodeClass}, selector2);
    }

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId systemId, @NotNull Project project2, @NotNull String title, final Class<? extends ExternalSystemNode>[] nodeClasses, @Nullable NodeSelector selector2) {
        super(project2, false);
        this.mySelector = selector2;
        this.setTitle(title);
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(1);
        ExternalProjectsView projectsView = ExternalProjectsManager.getInstance(project2).getExternalProjectsView(systemId);
        if (projectsView != null) {
            final ExternalProjectsStructure treeStructure = new ExternalProjectsStructure(project2, this.myTree){

                @Override
                protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
                    return nodeClasses;
                }

                @Override
                public Object getRootElement() {
                    Object rootElement = super.getRootElement();
                    return SelectExternalSystemNodeDialog.this.customizeProjectsTreeRoot(rootElement);
                }
            };
            Disposer.register((Disposable)this.myDisposable, (Disposable)treeStructure);
            treeStructure.init(new ExternalProjectsViewAdapter(projectsView){

                @Override
                @Nullable
                public ExternalProjectsStructure getStructure() {
                    return treeStructure;
                }

                @Override
                public void updateUpTo(ExternalSystemNode node) {
                    treeStructure.updateUpTo(node);
                }

                @Override
                public boolean getGroupTasks() {
                    return SelectExternalSystemNodeDialog.this.groupTasks != null ? SelectExternalSystemNodeDialog.this.groupTasks.booleanValue() : super.getGroupTasks();
                }

                @Override
                public boolean useTasksNode() {
                    return SelectExternalSystemNodeDialog.this.useTasksNode != null ? SelectExternalSystemNodeDialog.this.useTasksNode.booleanValue() : super.useTasksNode();
                }

                @Override
                public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
                    SelectExternalSystemNodeDialog.this.handleDoubleClickOrEnter(node, actionId, inputEvent);
                }
            });
            Collection<ExternalProjectInfo> projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project2, systemId);
            List dataNodes = ContainerUtil.mapNotNull(projectsData, info -> info.getExternalProjectStructure());
            treeStructure.updateProjects(dataNodes);
            TreeUtil.expandAll((JTree)this.myTree);
            if (this.mySelector != null) {
                final SimpleNode[] selection = new SimpleNode[]{null};
                treeStructure.accept(new SimpleNodeVisitor(){

                    public boolean accept(SimpleNode each) {
                        if (!SelectExternalSystemNodeDialog.this.mySelector.shouldSelect(each)) {
                            return false;
                        }
                        selection[0] = each;
                        return true;
                    }
                });
                if (selection[0] != null) {
                    treeStructure.select(selection[0]);
                }
            }
        }
        this.init();
    }

    protected Object customizeProjectsTreeRoot(Object rootElement) {
        return rootElement;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
    }

    protected SimpleNode getSelectedNode() {
        return this.myTree.getNodeFor(this.myTree.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return pane;
    }

    protected static interface NodeSelector {
        public boolean shouldSelect(SimpleNode var1);
    }
}

