/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemUiUtil {
    public static final int INSETS = 5;
    private static final int BALLOON_FADEOUT_TIME = 5000;

    private ExternalSystemUiUtil() {
    }

    public static void showBalloon(@NotNull JComponent component, @NotNull MessageType messageType, @NotNull String message2) {
        Balloon.Position position;
        int x;
        int y;
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, messageType, null).setDisposable((Disposable)ApplicationManager.getApplication()).setFadeoutTime(5000L);
        Balloon balloon = builder.createBalloon();
        Dimension size = component.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon.show(new RelativePoint((Component)component, new Point(x, y)), position);
    }

    @NotNull
    public static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        return new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
    }

    @NotNull
    public static GridBag getFillLineConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        return new GridBag().weightx(1.0).coverLine().fillCellHorizontally().anchor(17).insets((Insets)insets);
    }

    public static void fillBottom(@NotNull JComponent component) {
        component.add(Box.createVerticalGlue(), new GridBag().weightx(1.0).weighty(1.0).fillCell().coverLine());
    }

    public static void showUi(@NotNull Object o, boolean show) {
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    ((JComponent)v).setVisible(show);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static void disposeUi(@NotNull Object o) {
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    field.set(o, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public static ExternalSystemUiAware getUiAware(@NotNull ProjectSystemId externalSystemId) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        return manager instanceof ExternalSystemUiAware ? (ExternalSystemUiAware)manager : DefaultExternalSystemUiAware.INSTANCE;
    }

    public static void executeAction(@NotNull String actionId, @NotNull InputEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        if (action == null) {
            return;
        }
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext(e.getComponent());
        AnActionEvent event = new AnActionEvent(e, context, "", presentation, actionManager, 0);
        action.update(event);
        if (presentation.isEnabled()) {
            action.actionPerformed(event);
        }
    }
}

