/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EnforcedPlainTextFileTypeFactory
extends FileTypeFactory {
    public static final LayeredIcon ENFORCED_PLAIN_TEXT_ICON = new LayeredIcon(2);
    public static final String ENFORCED_PLAIN_TEXT = "Enforced Plain Text";
    private final FileTypeIdentifiableByVirtualFile myFileType = new FileTypeIdentifiableByVirtualFile(){

        @Override
        public boolean isMyFileType(@NotNull VirtualFile file2) {
            return EnforcedPlainTextFileTypeFactory.isMarkedAsPlainText(file2);
        }

        @NotNull
        public String getName() {
            return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
        }

        @NotNull
        public String getDescription() {
            return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
        }

        @NotNull
        public String getDefaultExtension() {
            return "fakeTxt";
        }

        public Icon getIcon() {
            return ENFORCED_PLAIN_TEXT_ICON;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
            return null;
        }
    };

    public void createFileTypes(@NotNull FileTypeConsumer consumer2) {
        consumer2.consume((FileType)this.myFileType, "");
    }

    private static boolean isMarkedAsPlainText(@NotNull VirtualFile file2) {
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        return typeManager != null && typeManager.isMarkedAsPlainText(file2);
    }

    static {
        ENFORCED_PLAIN_TEXT_ICON.setIcon(AllIcons.FileTypes.Text, 0);
        ENFORCED_PLAIN_TEXT_ICON.setIcon(PlatformIcons.EXCLUDED_FROM_COMPILE_ICON, 1);
    }
}

