/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacFileSaverDialog;
import com.intellij.ui.mac.MacPathChooserDialog;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserFactoryImpl
extends FileChooserFactory {
    @NotNull
    public FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor descriptor, @Nullable Project project2, @Nullable Component parent) {
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor)) {
            return new MacPathChooserDialog(descriptor, parent, project2);
        }
        if (parent != null) {
            return new FileChooserDialogImpl(descriptor, parent, project2);
        }
        return new FileChooserDialogImpl(descriptor, project2);
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor, @Nullable Project project2, @Nullable Component parent) {
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor)) {
            return new MacPathChooserDialog(descriptor, parent, project2);
        }
        if (parent != null) {
            return new FileChooserDialogImpl(descriptor, parent, project2);
        }
        return new FileChooserDialogImpl(descriptor, project2);
    }

    private static boolean useNativeMacChooser(FileChooserDescriptor descriptor) {
        return SystemInfo.isMac && !descriptor.isForcedToUseIdeaFileChooser() && SystemProperties.getBooleanProperty((String)"native.mac.file.chooser.enabled", (boolean)true) && Registry.is((String)"ide.mac.file.chooser.native") && SystemInfo.isJetbrainsJvm;
    }

    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor, boolean showHidden, @Nullable Disposable parent) {
        return new FileTextFieldImpl.Vfs(new JTextField(), FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor, showHidden));
    }

    public void installFileCompletion(@NotNull JTextField field, @NotNull FileChooserDescriptor descriptor, boolean showHidden, @Nullable Disposable parent) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new FileTextFieldImpl.Vfs(field, FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor, showHidden));
        }
    }

    public static Map<String, String> getMacroMap() {
        PathMacros macros = PathMacros.getInstance();
        Set allNames = macros.getAllMacroNames();
        THashMap map2 = new THashMap(allNames.size());
        for (String eachMacroName : allNames) {
            map2.put("$" + eachMacroName + "$", macros.getValue(eachMacroName));
        }
        return map2;
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor, @Nullable Project project2) {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor, project2) : new FileSaverDialogImpl(descriptor, project2);
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor, @NotNull Component parent) {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor, parent) : new FileSaverDialogImpl(descriptor, parent);
    }
}

