/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNode {
    private final VirtualFile myFile;
    private final AtomicReference<Icon> myIcon = new AtomicReference();
    private final AtomicReference<String> myName = new AtomicReference();
    private final AtomicReference<String> myComment = new AtomicReference();
    private final AtomicBoolean myValid = new AtomicBoolean();
    private final AtomicBoolean myHidden = new AtomicBoolean();
    private final AtomicBoolean mySpecial = new AtomicBoolean();
    private final AtomicBoolean mySymlink = new AtomicBoolean();
    private final AtomicBoolean myWritable = new AtomicBoolean();

    FileNode(@NotNull VirtualFile file2) {
        this.myFile = file2;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.myIcon.get();
    }

    boolean updateIcon(Icon icon) {
        return !Objects.equals(icon, this.myIcon.getAndSet(icon));
    }

    public String getName() {
        return this.myName.get();
    }

    boolean updateName(String name) {
        return !Objects.equals(name, this.myName.getAndSet(name));
    }

    public String getComment() {
        return this.myComment.get();
    }

    boolean updateComment(String comment) {
        return !Objects.equals(comment, this.myComment.getAndSet(comment));
    }

    public boolean isValid() {
        return this.myValid.get();
    }

    boolean updateValid(boolean valid) {
        return valid != this.myValid.getAndSet(valid);
    }

    public boolean isHidden() {
        return this.myHidden.get();
    }

    boolean updateHidden(boolean hidden) {
        return hidden != this.myHidden.getAndSet(hidden);
    }

    public boolean isSpecial() {
        return this.mySpecial.get();
    }

    boolean updateSpecial(boolean special) {
        return special != this.mySpecial.getAndSet(special);
    }

    public boolean isSymlink() {
        return this.mySymlink.get();
    }

    boolean updateSymlink(boolean symlink) {
        return symlink != this.mySymlink.getAndSet(symlink);
    }

    public boolean isWritable() {
        return this.myWritable.get();
    }

    boolean updateWritable(boolean writable) {
        return writable != this.myWritable.getAndSet(writable);
    }
}

