/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class FileTreeModel
extends AbstractTreeModel
implements Disposable,
InvokerSupplier {
    private final Invoker invoker = new Invoker.BackgroundThread(this);
    private final State state;
    private volatile List<Root> roots;

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor, FileRefresher refresher) {
        this(descriptor, refresher, true, false);
    }

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
        if (refresher != null) {
            Disposer.register((Disposable)this, (Disposable)refresher);
        }
        this.state = new State(descriptor, refresher, sortDirectories, sortArchives);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                FileTreeModel.this.invoker.invokeLaterIfNeeded(() -> FileTreeModel.this.process(events));
            }
        });
    }

    public void dispose() {
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    public final Object getRoot() {
        return this.state;
    }

    public final Object getChild(Object object, int index) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            if (0 <= index && index < this.roots.size()) {
                return this.roots.get(index);
            }
        } else if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChild(index);
        }
        return null;
    }

    public final int getChildCount(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            return this.roots.size();
        }
        if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChildCount();
        }
        return 0;
    }

    public final boolean isLeaf(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object != this.state && object instanceof Node && (entry = this.getEntry((Node)object, false)) != null) {
            return entry.isLeaf();
        }
        return false;
    }

    public final int getIndexOfChild(Object object, Object child) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                if (child != this.roots.get(i2)) continue;
                return i2;
            }
        } else if (object instanceof Node && child instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getIndexOf((Node)child);
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private boolean hasEntry(VirtualFile file2) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry entry = root.tree.findEntry(file2);
                if (entry == null) continue;
                return true;
            }
        }
        return false;
    }

    private MapBasedTree.Entry<Node> getEntry(Node node, boolean loadChildren) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> entry = root.tree.getEntry(node);
                if (entry == null) continue;
                if (loadChildren && entry.isLoadingRequired()) {
                    root.updateChildren(this.state, entry);
                }
                return entry;
            }
        }
        return null;
    }

    private void process(List<? extends VFileEvent> events) {
        if (this.roots == null) {
            return;
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VFileEvent virtualFile : events) {
            VirtualFile file2;
            if (virtualFile instanceof VFilePropertyChangeEvent) {
                if (!this.hasEntry(virtualFile.getFile())) continue;
                files.add(virtualFile.getFile());
                continue;
            }
            if (virtualFile instanceof VFileCreateEvent) {
                VFileCreateEvent create2 = (VFileCreateEvent)virtualFile;
                if (!this.hasEntry(create2.getParent())) continue;
                parents.add(create2.getParent());
                continue;
            }
            if (virtualFile instanceof VFileCopyEvent) {
                VFileCopyEvent copy = (VFileCopyEvent)virtualFile;
                if (!this.hasEntry(copy.getNewParent())) continue;
                parents.add(copy.getNewParent());
                continue;
            }
            if (virtualFile instanceof VFileMoveEvent) {
                VFileMoveEvent move = (VFileMoveEvent)virtualFile;
                if (this.hasEntry(move.getNewParent())) {
                    parents.add(move.getNewParent());
                }
                if (!this.hasEntry(move.getOldParent())) continue;
                parents.add(move.getOldParent());
                continue;
            }
            if (!(virtualFile instanceof VFileDeleteEvent) || !this.hasEntry(file2 = virtualFile.getFile())) continue;
            files.add(file2);
            file2 = file2.getParent();
            parents.add((VirtualFile)(this.hasEntry(file2) ? file2 : null));
        }
        for (VirtualFile virtualFile : parents) {
            for (Root root : this.roots) {
                boolean contained;
                MapBasedTree.Entry entry = root.tree.findEntry(virtualFile);
                if (entry == null) continue;
                MapBasedTree.UpdateResult update2 = root.updateChildren(this.state, entry);
                boolean removed = !update2.getRemoved().isEmpty();
                boolean inserted = !update2.getInserted().isEmpty();
                boolean bl = contained = !update2.getContained().isEmpty();
                if (!removed && !inserted && !contained) continue;
                if (!removed && inserted) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesInserted(update2.getEvent(this, entry, update2.getInserted()));
                    continue;
                }
                if (!inserted && removed) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesRemoved(update2.getEvent(this, entry, update2.getRemoved()));
                    continue;
                }
                this.treeStructureChanged(entry, null, null);
            }
        }
        for (VirtualFile virtualFile : files) {
        }
    }

    private static VirtualFile findFile(String path) {
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private static class Root
    extends Node {
        private final MapBasedTree<VirtualFile, Node> tree;

        private Root(State state, VirtualFile file2) {
            super(state, file2);
            this.tree = new MapBasedTree<VirtualFile, Node>(false, node -> node.getFile(), state.path);
            this.tree.updateRoot((Pair<Node, Boolean>)Pair.create((Object)this, (Object)state.isLeaf(file2)));
        }

        private MapBasedTree.UpdateResult<Node> updateChildren(State state, MapBasedTree.Entry<Node> parent) {
            VirtualFile[] children2 = state.getChildren(parent.getNode().getFile());
            if (children2 == null) {
                return this.tree.update(parent, null);
            }
            if (children2.length == 0) {
                return this.tree.update(parent, Collections.emptyList());
            }
            return this.tree.update(parent, Arrays.stream(children2).filter(x$0 -> state.isVisible(x$0)).sorted((x$0, x$1) -> state.compare(x$0, x$1)).map(file2 -> {
                MapBasedTree.Entry<Node> entry = this.tree.findEntry((VirtualFile)file2);
                return entry != null && parent == entry.getParentPath() ? Pair.create((Object)entry.getNode(), (Object)entry.isLeaf()) : Pair.create((Object)new Node(state, (VirtualFile)file2), (Object)state.isLeaf(file2));
            }).collect(Collectors.toList()));
        }
    }

    private static class Node
    extends FileNode {
        private boolean invalid;

        private Node(State state, VirtualFile file2) {
            super(file2);
            this.updateContent(state);
        }

        private boolean updateContent(State state) {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return this.updateName(state.descriptor.getTitle());
            }
            Icon icon = state.descriptor.getIcon(file2);
            String name = state.descriptor.getName(file2);
            String comment = state.descriptor.getComment(file2);
            if (name == null || comment == null) {
                name = file2.getName();
            }
            boolean updated = false;
            if (this.updateIcon(icon)) {
                updated = true;
            }
            if (this.updateName(name)) {
                updated = true;
            }
            if (this.updateComment(comment)) {
                updated = true;
            }
            if (this.updateValid(file2.isValid())) {
                updated = true;
            }
            if (this.updateHidden(FileElement.isFileHidden((VirtualFile)file2))) {
                updated = true;
            }
            if (this.updateSpecial(file2.is(VFileProperty.SPECIAL))) {
                updated = true;
            }
            if (this.updateSymlink(file2.is(VFileProperty.SYMLINK))) {
                updated = true;
            }
            if (this.updateWritable(file2.isWritable())) {
                updated = true;
            }
            return updated;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class State {
        private final TreePath path;
        private final FileChooserDescriptor descriptor;
        private final FileRefresher refresher;
        private final boolean sortDirectories;
        private final boolean sortArchives;
        private List<VirtualFile> roots;

        private State(FileChooserDescriptor descriptor, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
            this.path = new TreePath(descriptor);
            this.descriptor = descriptor;
            this.refresher = refresher;
            this.sortDirectories = sortDirectories;
            this.sortArchives = sortArchives;
            this.roots = State.getRoots(descriptor);
        }

        private int compare(VirtualFile one, VirtualFile two) {
            if (one == null && two == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (two == null) {
                return 1;
            }
            if (this.sortDirectories) {
                boolean isArchive;
                boolean isDirectory = one.isDirectory();
                if (isDirectory != two.isDirectory()) {
                    return isDirectory ? -1 : 1;
                }
                if (!isDirectory && this.sortArchives && this.descriptor.isChooseJarContents() && (isArchive = FileElement.isArchive((VirtualFile)one)) != FileElement.isArchive((VirtualFile)two)) {
                    return isArchive ? -1 : 1;
                }
            }
            return StringUtil.naturalCompare((String)one.getName(), (String)two.getName());
        }

        private static boolean isValid(VirtualFile file2) {
            return file2 != null && file2.isValid();
        }

        private boolean isVisible(VirtualFile file2) {
            return State.isValid(file2) && this.descriptor.isFileVisible(file2, this.descriptor.isShowHiddenFiles());
        }

        private boolean isLeaf(VirtualFile file2) {
            if (file2 == null || file2.isDirectory()) {
                return false;
            }
            return !this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2);
        }

        private VirtualFile[] getChildren(VirtualFile file2) {
            if (file2.isDirectory()) {
                return file2.getChildren();
            }
            if (!this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2)) {
                return null;
            }
            String path = file2.getPath() + "!/";
            VirtualFile jar = JarFileSystem.getInstance().findFileByPath(path);
            return jar == null ? VirtualFile.EMPTY_ARRAY : jar.getChildren();
        }

        private List<Root> getRoots() {
            List<VirtualFile> files = this.roots;
            if (this.roots == null) {
                files = State.getSystemRoots();
            }
            if (this.refresher != null && this.refresher.isRecursive()) {
                this.refresher.setFiles(files);
            }
            if (files.isEmpty()) {
                return Collections.emptyList();
            }
            return files.stream().map(file2 -> new Root(this, (VirtualFile)file2)).collect(Collectors.toList());
        }

        private static List<VirtualFile> getRoots(FileChooserDescriptor descriptor) {
            List<VirtualFile> list = descriptor.getRoots().stream().filter(State::isValid).collect(Collectors.toList());
            return list.isEmpty() && descriptor.isShowFileSystemRoots() ? null : list;
        }

        private static List<VirtualFile> getSystemRoots() {
            File[] roots = File.listRoots();
            return roots == null || roots.length == 0 ? Collections.emptyList() : Arrays.stream(roots).map(root -> FileTreeModel.findFile(root.getAbsolutePath())).filter(State::isValid).collect(Collectors.toList());
        }

        public String toString() {
            return this.descriptor.getTitle();
        }
    }
}

