/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EditorWithProviderComposite
extends EditorComposite {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite");
    private FileEditorProvider[] myProviders;

    EditorWithProviderComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers, @NotNull FileEditorManagerEx fileEditorManager) {
        super(file2, editors, fileEditorManager);
        this.myProviders = providers;
    }

    @NotNull
    public FileEditorProvider[] getProviders() {
        return this.myProviders;
    }

    @Override
    public boolean isModified() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.getEditors()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        int index;
        LOG.assertTrue(this.myEditors.length > 0, (Object)this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            return Pair.create((Object)this.myEditors[0], (Object)this.myProviders[0]);
        }
        int n = index = this.myTabbedPaneWrapper != null ? this.myTabbedPaneWrapper.getSelectedIndex() : 0;
        if (index == -1) {
            index = 0;
        }
        LOG.assertTrue(index >= 0, (Object)index);
        LOG.assertTrue(index < this.myEditors.length, (Object)index);
        return Pair.create((Object)this.myEditors[index], (Object)this.myProviders[index]);
    }

    @NotNull
    public HistoryEntry currentStateAsHistoryEntry() {
        Object[] editors = this.getEditors();
        FileEditorState[] states = new FileEditorState[editors.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find((Object[])editors, (Object)this.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = this.getProviders();
        return HistoryEntry.createLight(this.getFile(), providers, states, providers[selectedProviderIndex]);
    }

    public void addEditor(@NotNull FileEditor editor, FileEditorProvider provider2) {
        this.addEditor(editor);
        this.myProviders = (FileEditorProvider[])ArrayUtil.append((Object[])this.myProviders, (Object)provider2);
    }
}

