/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorProviderManager", storages={@Storage(value="fileEditorProviderManager.xml", roamingType=RoamingType.DISABLED)})
public final class FileEditorProviderManagerImpl
extends FileEditorProviderManager
implements PersistentStateComponent<FileEditorProviderManagerImpl> {
    private final List<FileEditorProvider> myProviders = ContainerUtil.createConcurrentList();
    private final Map<String, String> mySelectedProviders = new HashMap<String, String>();

    public FileEditorProviderManagerImpl(@NotNull FileEditorProvider[] providers) {
        Extensions.getRootArea().getExtensionPoint(FileEditorProvider.EP_FILE_EDITOR_PROVIDER).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionAdded(@NotNull FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                FileEditorProviderManagerImpl.this.registerProvider(extension);
            }

            public void extensionRemoved(@NotNull FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                FileEditorProviderManagerImpl.this.unregisterProvider(extension);
            }
        });
        for (FileEditorProvider provider2 : providers) {
            this.registerProvider(provider2);
        }
    }

    public FileEditorProviderManagerImpl() {
    }

    @Override
    @NotNull
    public FileEditorProvider[] getProviders(@NotNull Project project2, @NotNull VirtualFile file2) {
        ArrayList<FileEditorProvider> sharedProviders = new ArrayList<FileEditorProvider>();
        boolean doNotShowTextEditor = false;
        for (FileEditorProvider provider3 : this.myProviders) {
            if (!((Boolean)ReadAction.compute(() -> {
                if (project2.isDisposed() || DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)provider3)) {
                    return false;
                }
                return provider3.accept(project2, file2);
            })).booleanValue()) continue;
            sharedProviders.add(provider3);
            doNotShowTextEditor |= provider3.getPolicy() == FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        }
        if (doNotShowTextEditor) {
            ContainerUtil.retainAll(sharedProviders, provider2 -> !(provider2 instanceof TextEditorProvider));
        }
        Collections.sort(sharedProviders, MyComparator.ourInstance);
        return sharedProviders.toArray(new FileEditorProvider[sharedProviders.size()]);
    }

    @Override
    @Nullable
    public FileEditorProvider getProvider(@NotNull String editorTypeId) {
        for (FileEditorProvider provider2 : this.myProviders) {
            if (!provider2.getEditorTypeId().equals(editorTypeId)) continue;
            return provider2;
        }
        return null;
    }

    private void registerProvider(@NotNull FileEditorProvider provider2) {
        String editorTypeId = provider2.getEditorTypeId();
        if (this.getProvider(editorTypeId) != null) {
            throw new IllegalArgumentException("attempt to register provider with non unique editorTypeId: " + editorTypeId);
        }
        this.myProviders.add(provider2);
    }

    private void unregisterProvider(@NotNull FileEditorProvider provider2) {
        boolean b = this.myProviders.remove(provider2);
        assert (b);
    }

    @Nullable
    public FileEditorProviderManagerImpl getState() {
        return this;
    }

    public void loadState(FileEditorProviderManagerImpl state) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(state.mySelectedProviders);
    }

    void providerSelected(EditorComposite composite) {
        if (!(composite instanceof EditorWithProviderComposite)) {
            return;
        }
        FileEditorProvider[] providers = ((EditorWithProviderComposite)composite).getProviders();
        if (providers.length < 2) {
            return;
        }
        this.mySelectedProviders.put(FileEditorProviderManagerImpl.computeKey(providers), ((FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond()).getEditorTypeId());
    }

    private static String computeKey(FileEditorProvider[] providers) {
        return StringUtil.join((Collection)ContainerUtil.map((Object[])providers, FileEditorProvider::getEditorTypeId), (String)",");
    }

    @Nullable
    FileEditorProvider getSelectedFileEditorProvider(EditorHistoryManager editorHistoryManager, VirtualFile file2, FileEditorProvider[] providers) {
        FileEditorProvider provider2 = editorHistoryManager.getSelectedProvider(file2);
        if (provider2 != null || providers.length < 2) {
            return provider2;
        }
        String id = this.mySelectedProviders.get(FileEditorProviderManagerImpl.computeKey(providers));
        return id == null ? null : this.getProvider(id);
    }

    @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> getSelectedProviders() {
        return this.mySelectedProviders;
    }

    public void setSelectedProviders(Map<String, String> selectedProviders) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(selectedProviders);
    }

    public void clearSelectedProviders() {
        this.mySelectedProviders.clear();
    }

    private static final class MyComparator
    implements Comparator<FileEditorProvider> {
        public static final MyComparator ourInstance = new MyComparator();

        private MyComparator() {
        }

        private static double getWeight(FileEditorProvider provider2) {
            return provider2 instanceof WeighedFileEditorProvider ? ((WeighedFileEditorProvider)provider2).getWeight() : Double.MAX_VALUE;
        }

        @Override
        public int compare(FileEditorProvider provider1, FileEditorProvider provider2) {
            int i2;
            int i1 = provider1.getPolicy().ordinal();
            if (i1 != (i2 = provider2.getPolicy().ordinal())) {
                return i1 - i2;
            }
            double value2 = MyComparator.getWeight(provider1) - MyComparator.getWeight(provider2);
            return value2 > 0.0 ? 1 : (value2 < 0.0 ? -1 : 0);
        }
    }
}

