/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.docking.DockManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePreviewPanelProvider
extends PreviewPanelProvider<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> {
    public static final PreviewProviderId<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> ID = PreviewProviderId.create("Files");
    private final FileEditorManagerImpl myManager;
    private final Project myProject;
    private final EditorWindow myWindow;
    private final EditorsSplitters myEditorsSplitters;

    public FilePreviewPanelProvider(@NotNull Project project2, @NotNull FileEditorManagerImpl manager, @NotNull DockManager dockManager) {
        super(ID);
        this.myProject = project2;
        this.myManager = manager;
        this.myEditorsSplitters = new MyEditorsSplitters(manager, dockManager, false);
        Disposer.register((Disposable)this, (Disposable)this.myEditorsSplitters);
        this.myEditorsSplitters.createCurrentWindow();
        this.myWindow = this.myEditorsSplitters.getCurrentWindow();
        this.myWindow.setTabsPlacement(0);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myEditorsSplitters;
    }

    @Override
    protected Pair<FileEditor[], FileEditorProvider[]> initComponent(VirtualFile file2, boolean requestFocus) {
        Pair<FileEditor[], FileEditorProvider[]> result2 = this.myManager.openFileWithProviders(file2, requestFocus, this.myWindow);
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> this.myWindow.requestFocus(true));
        return result2;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull VirtualFile file2) {
        return EditorTabbedContainer.calcTabTitle(this.myProject, file2);
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull VirtualFile file2) {
        return file2.getFileType().getIcon();
    }

    @Override
    public float getMenuOrder() {
        return 0.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull VirtualFile file2) {
        EditorWindow window = this.myManager.getCurrentWindow();
        if (window == null) {
            this.myManager.getMainSplitters().createCurrentWindow();
            window = this.myManager.getCurrentWindow();
        }
        this.myManager.openFileWithProviders(file2, true, window);
    }

    @Override
    public boolean isModified(VirtualFile content, boolean beforeReuse) {
        for (EditorWithProviderComposite composite : this.myEditorsSplitters.getEditorsComposites()) {
            if (!composite.isModified() || !Comparing.equal((Object)composite.getFile(), (Object)content)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void release(@NotNull VirtualFile content) {
        this.myEditorsSplitters.closeFile(content, false);
    }

    @Override
    public boolean contentsAreEqual(@NotNull VirtualFile content1, @NotNull VirtualFile content2) {
        return Comparing.equal((Object)content1, (Object)content2);
    }

    private class MyEditorsSplitters
    extends EditorsSplitters {
        private MyEditorsSplitters(FileEditorManagerImpl manager, DockManager dockManager, boolean createOwnDockableContainer) {
            super(manager, dockManager, createOwnDockableContainer);
        }

        @Override
        protected void afterFileClosed(VirtualFile file2) {
            PreviewManager.SERVICE.close(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), file2);
        }

        @Override
        protected EditorWindow createEditorWindow() {
            return new EditorWindow(this){

                @Override
                protected void onBeforeSetEditor(VirtualFile file2) {
                    for (EditorWithProviderComposite composite : MyEditorsSplitters.this.getEditorsComposites()) {
                        if (!composite.isModified()) continue;
                        PreviewManager.SERVICE.moveToStandardPlaceImpl(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), composite.getFile());
                        return;
                    }
                }
            };
        }

        @Override
        public void setTabsPlacement(int tabPlacement) {
            super.setTabsPlacement(0);
        }

        @Override
        public boolean isPreview() {
            return true;
        }
    }
}

