/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HistoryEntry {
    @NonNls
    static final String TAG = "entry";
    private static final String FILE_ATTR = "file";
    @NonNls
    private static final String PROVIDER_ELEMENT = "provider";
    @NonNls
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    private static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    private static final String STATE_ELEMENT = "state";
    @NotNull
    private final VirtualFilePointer myFilePointer;
    @Nullable
    private FileEditorProvider mySelectedProvider;
    @NotNull
    private final HashMap<FileEditorProvider, FileEditorState> myProvider2State;
    @Nullable
    private final Disposable myDisposable;

    private HistoryEntry(@NotNull VirtualFilePointer filePointer, @Nullable FileEditorProvider selectedProvider, @Nullable Disposable disposable) {
        this.myFilePointer = filePointer;
        this.mySelectedProvider = selectedProvider;
        this.myDisposable = disposable;
        this.myProvider2State = new HashMap();
    }

    @NotNull
    static HistoryEntry createLight(@NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        LightFilePointer pointer = new LightFilePointer(file2);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, null);
        for (int i = 0; i < providers.length; ++i) {
            entry.putState(providers[i], states[i]);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createLight(@NotNull Project project2, @NotNull Element e) throws InvalidDataException {
        EntryData entryData = HistoryEntry.parseEntry(project2, e);
        LightFilePointer pointer = new LightFilePointer(entryData.url);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, null);
        for (Pair state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (project2.isDisposed()) {
            return HistoryEntry.createLight(file2, providers, states, selectedProvider);
        }
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(file2, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, disposable);
        for (int i = 0; i < providers.length; ++i) {
            FileEditorProvider provider2 = providers[i];
            FileEditorState state = states[i];
            if (provider2 == null || state == null) continue;
            entry.putState(provider2, state);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project2, @NotNull Element e) throws InvalidDataException {
        if (project2.isDisposed()) {
            return HistoryEntry.createLight(project2, e);
        }
        EntryData entryData = HistoryEntry.parseEntry(project2, e);
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(entryData.url, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, disposable);
        for (Pair state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        return entry;
    }

    @NotNull
    public VirtualFilePointer getFilePointer() {
        return this.myFilePointer;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFilePointer.getFile();
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider2) {
        return (FileEditorState)this.myProvider2State.get((Object)provider2);
    }

    void putState(@NotNull FileEditorProvider provider2, @NotNull FileEditorState state) {
        this.myProvider2State.put((Object)provider2, (Object)state);
    }

    @Nullable
    FileEditorProvider getSelectedProvider() {
        return this.mySelectedProvider;
    }

    void setSelectedProvider(@Nullable FileEditorProvider value2) {
        this.mySelectedProvider = value2;
    }

    public void destroy() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    public Element writeExternal(Element element, Project project2) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFilePointer.getUrl());
        for (Map.Entry entry : this.myProvider2State.entrySet()) {
            FileEditorProvider provider2 = (FileEditorProvider)entry.getKey();
            Element providerElement = new Element(PROVIDER_ELEMENT);
            if (provider2.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider2.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            providerElement.addContent(stateElement);
            provider2.writeState((FileEditorState)entry.getValue(), project2, stateElement);
            e.addContent(providerElement);
        }
        return e;
    }

    @NotNull
    private static EntryData parseEntry(@NotNull Project project2, @NotNull Element e) throws InvalidDataException {
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        ArrayList<Pair<FileEditorProvider, FileEditorState>> providerStates = new ArrayList<Pair<FileEditorProvider, FileEditorState>>();
        FileEditorProvider selectedProvider = null;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        for (Element _e : e.getChildren(PROVIDER_ELEMENT)) {
            Element stateElement;
            String typeId = _e.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider2 = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider2 == null) continue;
            if (Boolean.valueOf(_e.getAttributeValue(SELECTED_ATTR_VALUE)).booleanValue()) {
                selectedProvider = provider2;
            }
            if ((stateElement = _e.getChild(STATE_ELEMENT)) == null) {
                throw new InvalidDataException();
            }
            if (file2 == null) continue;
            FileEditorState state = provider2.readState(stateElement, project2, file2);
            providerStates.add((Pair<FileEditorProvider, FileEditorState>)Pair.create((Object)provider2, (Object)state));
        }
        return new EntryData(url, providerStates, selectedProvider);
    }

    private static class EntryData {
        @NotNull
        private final String url;
        @NotNull
        private final List<Pair<FileEditorProvider, FileEditorState>> providerStates;
        @Nullable
        private final FileEditorProvider selectedProvider;

        EntryData(@NotNull String url, @NotNull List<Pair<FileEditorProvider, FileEditorState>> providerStates, @Nullable FileEditorProvider selectedProvider) {
            this.url = url;
            this.providerStates = providerStates;
            this.selectedProvider = selectedProvider;
        }
    }
}

