/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    @Nls
    private static final String AUTO_DETECTED_FROM_BOM = "auto-detected from BOM";
    private static final int UNLIMITED = -1;
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create((String)"CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparators(@NotNull CharBuffer buffer) {
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return Pair.create((Object)result2, (Object)detectedLineSeparator);
    }

    @NotNull
    private static Charset detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content, @NotNull FileType fileType) {
        Charset charset = null;
        String charsetName = fileType.getCharset(virtualFile, content);
        if (charsetName != null) {
            charset = CharsetToolkit.forName((String)charsetName);
        } else {
            Charset hardCodedCharset;
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, content.length);
            Charset charset2 = hardCodedCharset = guessed == null ? null : (Charset)guessed.first;
            if (hardCodedCharset == null) {
                Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
                if (specifiedExplicitly != null) {
                    charset = specifiedExplicitly;
                }
            } else {
                charset = hardCodedCharset;
            }
        }
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
        }
        virtualFile.setCharset(charset);
        return charset;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        return (Charset)LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, true, virtualFile.getFileType()).getFirst();
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, boolean saveBOM, @NotNull FileType fileType) {
        Charset charset = virtualFile.isCharsetSet() ? virtualFile.getCharset() : LoadTextUtil.detectCharset(virtualFile, content, fileType);
        Pair.NonNull<Charset, byte[]> bomAndCharset = LoadTextUtil.getCharsetAndBOM(content, charset);
        byte[] bom = (byte[])bomAndCharset.second;
        if (saveBOM && bom.length != 0) {
            virtualFile.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
        return bomAndCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        String detectedFromBytes;
        block6: {
            CharsetToolkit.GuessedEncoding guessed;
            block8: {
                CharsetToolkit toolkit;
                block7: {
                    Charset defaultCharset = (Charset)ObjectUtils.notNull((Object)EncodingManager.getInstance().getEncoding(virtualFile, true), (Object)CharsetToolkit.getDefaultSystemCharset());
                    toolkit = GUESS_UTF ? new CharsetToolkit(content, defaultCharset) : null;
                    detectedFromBytes = null;
                    if (!GUESS_UTF) break block6;
                    toolkit.setEnforce8Bit(true);
                    Charset charset = toolkit.guessFromBOM();
                    if (charset == null) break block7;
                    detectedFromBytes = AUTO_DETECTED_FROM_BOM;
                    byte[] bom = (byte[])ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)charset), (Object)CharsetToolkit.UTF8_BOM);
                    Trinity trinity = Trinity.create((Object)charset, null, (Object)bom);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                    return trinity;
                }
                guessed = toolkit.guessFromContent(length);
                if (guessed != CharsetToolkit.GuessedEncoding.VALID_UTF8) break block8;
                detectedFromBytes = "auto-detected from bytes";
                Trinity trinity = Trinity.create((Object)CharsetToolkit.UTF8_CHARSET, (Object)guessed, null);
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                return trinity;
            }
            if (guessed != CharsetToolkit.GuessedEncoding.SEVEN_BIT) break block6;
            Trinity trinity = Trinity.create(null, (Object)guessed, null);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
            return trinity;
        }
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = null;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
        }
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getCharsetAndBOM(@NotNull byte[] content, @NotNull Charset charset) {
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom((byte[])content)) {
            return Pair.createNonNull((Object)charset, (Object)CharsetToolkit.UTF8_BOM);
        }
        try {
            Charset fromBOM = CharsetToolkit.guessFromBOM((byte[])content);
            if (fromBOM != null) {
                return Pair.createNonNull((Object)fromBOM, (Object)ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)fromBOM), (Object)ArrayUtil.EMPTY_BYTE_ARRAY));
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return Pair.createNonNull((Object)charset, (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public static void changeLineSeparators(@Nullable Project project2, @NotNull VirtualFile file2, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2, true, false);
        String currentSeparator = LoadTextUtil.detectLineSeparator(file2, false);
        if (newSeparator.equals(currentSeparator)) {
            return;
        }
        String newText = StringUtil.convertLineSeparators((String)currentText.toString(), (String)newSeparator);
        file2.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project2, file2, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project2, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project2, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        virtualFile.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project2, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project2, virtualFile, text);
        Pair.NonNull chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM((byte[])bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull((Object)fromBom, (Object)LoadTextUtil.toBytes(text, fromBom));
        }
        return chosen;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        try {
            if (specified.equals(existing)) {
                return Pair.createNonNull((Object)specified, (Object)LoadTextUtil.toBytes(text, existing));
            }
            byte[] out = LoadTextUtil.isSupported(specified, text);
            if (out != null) {
                return Pair.createNonNull((Object)specified, (Object)out);
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out != null) {
                return Pair.createNonNull((Object)existing, (Object)out);
            }
            return Pair.createNonNull((Object)specified, (Object)LoadTextUtil.toBytes(text, specified));
        }
        catch (RuntimeException e) {
            return Pair.createNonNull((Object)Charset.defaultCharset(), (Object)LoadTextUtil.toBytes(text, null));
        }
    }

    @NotNull
    private static byte[] toBytes(@NotNull String text, @Nullable Charset charset) throws RuntimeException {
        return charset == null ? text.getBytes() : text.getBytes(charset);
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project2, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return (Charset)ObjectUtils.notNull((Object)LoadTextUtil.charsetFromContentOrNull(project2, virtualFile, text), (Object)virtualFile.getCharset());
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project2, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return CharsetUtil.extractCharsetFromFileContent((Project)project2, (VirtualFile)virtualFile, (FileType)virtualFile.getFileType(), (CharSequence)text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2) {
        FileType type2 = file2.getFileType();
        if (type2.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(type2);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file2);
                try {
                    StringUtil.assertValidSeparators((CharSequence)text);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                return text;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file2.getPresentableUrl() + ". File type: " + type2.getName());
        }
        return LoadTextUtil.loadText(file2, -1);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2, int limit) {
        FileType type2 = file2.getFileType();
        if (type2.isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file2.getPresentableUrl() + ". File type: " + type2.getName());
        }
        if (file2 instanceof LightVirtualFile) {
            return LoadTextUtil.limitCharSequence(((LightVirtualFile)file2).getContent(), limit);
        }
        if (file2.isDirectory()) {
            throw new AssertionError((Object)("'" + file2.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file2.contentsToByteArray() : FileUtil.loadFirstAndClose((InputStream)file2.getInputStream(), (int)limit);
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file2);
        }
        catch (IOException e) {
            return ArrayUtil.EMPTY_CHAR_SEQUENCE;
        }
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence, int limit) {
        return limit == -1 ? sequence : sequence.subSequence(0, Math.min(limit, sequence.length()));
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, saveDetectedSeparators, saveBOM, virtualFile.getFileType());
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType) {
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, saveBOM, fileType);
        Charset charset = (Charset)pair.getFirst();
        byte[] bom = (byte[])pair.getSecond();
        int offset = bom.length;
        Pair<CharSequence, String> result2 = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (saveDetectedSeparators) {
            virtualFile.setDetectedLineSeparator((String)result2.getSecond());
        }
        return (CharSequence)result2.getFirst();
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file2, boolean checkFile) {
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2);
                lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    static String getDetectedLineSeparator(@NotNull VirtualFile file2) {
        return file2.getDetectedLineSeparator();
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull Charset charset) {
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getCharsetAndBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        int offset = bom.length;
        Pair<CharSequence, String> result2 = LoadTextUtil.convertBytes(bytes, (Charset)pair.first, offset);
        return (CharSequence)result2.getFirst();
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, @NotNull Charset charset, int startOffset) {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        return LoadTextUtil.convertLineSeparators(charBuffer);
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static String wasCharsetDetectedFromBytes(@NotNull VirtualFile virtualFile) {
        return (String)virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES);
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, (Object)reason);
    }
}

