/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> ENABLE_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_ENABLE_IN_TESTS");
    private static final NotNullLazyKey<AtomicInteger, UserDataHolder> ACCESS_ALLOWED = NotNullLazyKey.create((String)"NON_PROJECT_FILE_ACCESS", holder -> new AtomicInteger());
    private static final AtomicBoolean myInitialized = new AtomicBoolean();
    @NotNull
    private final Project myProject;
    @Nullable
    private static NullableFunction<List<VirtualFile>, UnlockOption> ourCustomUnlocker;

    public static void setCustomUnlocker(@Nullable NullableFunction<List<VirtualFile>, UnlockOption> unlocker) {
        ourCustomUnlocker = unlocker;
    }

    public NonProjectFileWritingAccessProvider(@NotNull Project project2) {
        this.myProject = project2;
        if (myInitialized.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new OurVirtualFileAdapter());
        }
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return Collections.emptyList();
        }
        List<VirtualFile> deniedFiles = Stream.of(files).filter(o -> !NonProjectFileWritingAccessProvider.isWriteAccessAllowed(o, this.myProject)).collect(Collectors.toList());
        if (deniedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        UnlockOption unlockOption = this.askToUnlock(deniedFiles);
        if (unlockOption == null) {
            return deniedFiles;
        }
        switch (unlockOption) {
            case UNLOCK: {
                NonProjectFileWritingAccessProvider.allowWriting(deniedFiles);
                break;
            }
            case UNLOCK_DIR: {
                NonProjectFileWritingAccessProvider.allowWriting(ContainerUtil.map(deniedFiles, VirtualFile::getParent));
                break;
            }
            case UNLOCK_ALL: {
                ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)NonProjectFileWritingAccessProvider.getApp())).incrementAndGet();
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private UnlockOption askToUnlock(@NotNull List<VirtualFile> files) {
        if (ourCustomUnlocker != null) {
            return (UnlockOption)((Object)ourCustomUnlocker.fun(files));
        }
        NonProjectFileWritingAccessDialog dialog2 = new NonProjectFileWritingAccessDialog(this.myProject, files);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getUnlockOption();
    }

    public static boolean isWriteAccessAllowed(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return true;
        }
        if (file2.isDirectory()) {
            return true;
        }
        if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
            return true;
        }
        if (file2.getFileSystem() instanceof TempFileSystem) {
            return true;
        }
        if (ArrayUtil.contains((Object)file2, (Object[])IdeDocumentHistory.getInstance(project2).getChangedFiles())) {
            return true;
        }
        if (!NonProjectFileWritingAccessProvider.getApp().isUnitTestMode() && FileUtil.isAncestor((File)new File(FileUtil.getTempDirectory()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)true)) {
            return true;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            if (((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)each)).get() <= 0) continue;
            return true;
        }
        return NonProjectFileWritingAccessProvider.isProjectFile(file2, project2);
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        for (NonProjectFileWritingAccessExtension each : (NonProjectFileWritingAccessExtension[])Extensions.getExtensions(NonProjectFileWritingAccessExtension.EP_NAME, (AreaInstance)project2)) {
            if (each.isWritable(file2)) {
                return true;
            }
            if (!each.isNotWritable(file2)) continue;
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        if (fileIndex.isInContent(file2)) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcluded(file2) && !fileIndex.isUnderIgnored(file2)) {
            return true;
        }
        if (project2 instanceof ProjectEx && !project2.isDefault()) {
            if (ProjectKt.getStateStore(project2).isProjectFile(file2)) {
                return true;
            }
            String filePath = file2.getPath();
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                if (!FileUtil.namesEqual((String)filePath, (String)module2.getModuleFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    public static void allowWriting(VirtualFile ... allowedFiles) {
        NonProjectFileWritingAccessProvider.allowWriting(Arrays.asList(allowedFiles));
    }

    public static void allowWriting(Iterable<VirtualFile> allowedFiles) {
        for (VirtualFile eachAllowed : allowedFiles) {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)eachAllowed)).incrementAndGet();
        }
    }

    public static void disableChecksDuring(@NotNull Runnable runnable2) {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).incrementAndGet();
        try {
            runnable2.run();
        }
        finally {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).decrementAndGet();
        }
    }

    public static void enableChecksInTests(@NotNull Disposable disposable) {
        NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, (Object)Boolean.TRUE);
        NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        Disposer.register((Disposable)disposable, () -> {
            NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        });
    }

    private static boolean isAllAccessAllowed() {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        if (app.isUnitTestMode() && app.getUserData(ENABLE_IN_TESTS) != Boolean.TRUE) {
            return true;
        }
        return ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).get() > 0;
    }

    private static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private static class OurVirtualFileAdapter
    extends VirtualFileAdapter {
        private OurVirtualFileAdapter() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            OurVirtualFileAdapter.unlock(event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            OurVirtualFileAdapter.unlock((VirtualFileEvent)event);
        }

        private static void unlock(@NotNull VirtualFileEvent event) {
            if (!event.isFromRefresh() && !event.getFile().isDirectory()) {
                NonProjectFileWritingAccessProvider.allowWriting(event.getFile());
            }
        }
    }

    public static enum UnlockOption {
        UNLOCK,
        UNLOCK_DIR,
        UNLOCK_ALL;

    }
}

