/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareFileEditorManagerImpl");
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public PsiAwareFileEditorManagerImpl(Project project2, PsiManager psiManager, WolfTheProblemSolver problemSolver, DockManager dockManager) {
        super(project2, dockManager);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myProblemListener = new MyProblemListener();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        project2.getMessageBus().connect().subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        });
    }

    @Override
    protected void projectOpened(@NotNull MessageBusConnection connection) {
        super.projectOpened(connection);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myProblemSolver.addProblemListener(this.myProblemListener);
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        StringBuilder tooltipText = new StringBuilder();
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject());
        if (module2 != null) {
            tooltipText.append("[");
            tooltipText.append(module2.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl()));
        return tooltipText.toString();
    }

    @Override
    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (!focusEditor || documentManager.isUncommited(document)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            if ("roots".equals(e.getPropertyName())) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                VirtualFile[] openFiles = PsiAwareFileEditorManagerImpl.this.getOpenFiles();
                for (int i = openFiles.length - 1; i >= 0; --i) {
                    VirtualFile file2 = openFiles[i];
                    LOG.assertTrue(file2 != null);
                    PsiAwareFileEditorManagerImpl.this.updateFileIcon(file2);
                }
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        private void doChange(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 == null) {
                return;
            }
            FileEditor[] editors = PsiAwareFileEditorManagerImpl.this.getAllEditors(file2);
            if (editors.length == 0) {
                return;
            }
            VirtualFile currentFile = PsiAwareFileEditorManagerImpl.this.getCurrentFile();
            if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
                PsiAwareFileEditorManagerImpl.this.updateFileIcon(currentFile);
            }
        }
    }
}

