/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(Project project2, VirtualFile file2) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, file2, false);
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(Project project2, VirtualFile vFile) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, vFile, true);
    }

    private static String getUniqueVirtualFilePath(Project project2, VirtualFile file2, boolean skipNonOpenedFiles) {
        String fileName;
        ConcurrentMap valueMap;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> key2 = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data = (CachedValue)project2.getUserData(key2);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)ContainerUtil.createConcurrentSoftValueMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT}), false);
            project2.putUserData(key2, (Object)data);
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)(valueMap = (ConcurrentMap)data.getValue()).get(fileName = file2.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName, project2, skipNonOpenedFiles, ProjectScope.getProjectScope((Project)project2));
            valueMap.put(fileName, builder != null ? builder : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file2)) {
            if (file2 instanceof VirtualFilePathWrapper) {
                return ((VirtualFilePathWrapper)file2).getPresentablePath();
            }
            return uniqueNameBuilderForShortName.getShortPath((Object)file2);
        }
        return file2.getName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName, Project project2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project2, fileName, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile2 : FileEditorManager.getInstance((Project)project2).getOpenFiles()) {
            if (!openFile2.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile2);
        }
        if (!skipNonOpenedFiles) {
            for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project2).getFiles()) {
                if (!recentlyEditedFile.getName().equals(fileName)) continue;
                setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
            }
        }
        if ((filesWithSameName = setOfFilesWithTheSameName).size() > 1) {
            String path = project2.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                builder.addPath((Object)virtualFile, virtualFile.getPath());
            }
            return builder;
        }
        return null;
    }
}

