/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.http.LocalFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class JumpFromRemoteFileToLocalAction
extends AnAction {
    private final HttpVirtualFile myFile;
    private final Project myProject;

    public JumpFromRemoteFileToLocalAction(HttpVirtualFile file2, Project project2) {
        super("Find Local File", "", AllIcons.General.AutoscrollToSource);
        this.myFile = file2;
        this.myProject = project2;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myFile.getFileInfo().getState() == RemoteFileState.DOWNLOADED);
    }

    public void actionPerformed(AnActionEvent e) {
        Collection<VirtualFile> files = JumpFromRemoteFileToLocalAction.findLocalFiles(this.myProject, Urls.newFromVirtualFile(this.myFile), this.myFile.getName());
        if (files.isEmpty()) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Cannot find local file for '" + this.myFile.getUrl() + "'"), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (files.size() == 1) {
            JumpFromRemoteFileToLocalAction.navigateToFile(this.myProject, (VirtualFile)ContainerUtil.getFirstItem(files, null));
        } else {
            JBList list = new JBList(files);
            list.setCellRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                    FileAppearanceService.getInstance().forVirtualFile((VirtualFile)value2).customize((SimpleColoredComponent)this);
                }
            });
            new PopupChooserBuilder((JList)list).setTitle("Select Target File").setMovable(true).setItemChoosenCallback(() -> this.lambda$actionPerformed$0((JList)list)).createPopup().showUnderneathOf(e.getInputEvent().getComponent());
        }
    }

    private static Collection<VirtualFile> findLocalFiles(Project project2, Url url, String fileName) {
        for (LocalFileFinder finder : (LocalFileFinder[])LocalFileFinder.EP_NAME.getExtensions()) {
            VirtualFile file2 = finder.findLocalFile(url, project2);
            if (file2 == null) continue;
            return Collections.singletonList(file2);
        }
        return FilenameIndex.getVirtualFilesByName(project2, fileName, GlobalSearchScope.allScope((Project)project2));
    }

    private static void navigateToFile(Project project2, @NotNull VirtualFile file2) {
        new OpenFileDescriptor(project2, file2).navigate(true);
    }

    private /* synthetic */ void lambda$actionPerformed$0(JList list) {
        for (Object value2 : list.getSelectedValues()) {
            JumpFromRemoteFileToLocalAction.navigateToFile(this.myProject, (VirtualFile)value2);
        }
    }
}

