/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class AsyncHighlighterUpdater
extends ReadTask {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncEditorLoader pool", (int)2);
    private static final Set<Future<?>> ourHighlighterFutures = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final Editor myEditor;
    private final VirtualFile myFile;

    private AsyncHighlighterUpdater(Project project2, Editor editor, VirtualFile file2) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file2;
    }

    @Override
    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (!this.isEverythingValid()) {
            return null;
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile);
        return new ReadTask.Continuation(() -> ((EditorEx)this.myEditor).setHighlighter(highlighter));
    }

    @Override
    public void onCanceled(@NotNull ProgressIndicator indicator) {
        AsyncHighlighterUpdater.updateHighlighters(this.myProject, this.myEditor, this.myFile);
    }

    private boolean isEverythingValid() {
        return !this.myProject.isDisposed() && !this.myEditor.isDisposed() && this.myFile.isValid();
    }

    public static void updateHighlighters(@NotNull Project project2, @NotNull Editor editor, @NotNull VirtualFile file2) {
        AsyncHighlighterUpdater task = new AsyncHighlighterUpdater(project2, editor, file2);
        if (task.isEverythingValid()) {
            CompletableFuture<?> future2 = ProgressIndicatorUtils.scheduleWithWriteActionPriority(ourExecutor, (ReadTask)task);
            ourHighlighterFutures.add(future2);
            future2.whenComplete((a, b) -> ourHighlighterFutures.remove(future2));
        }
    }

    public static void completeAsyncTasks() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ApplicationManager.getApplication().invokeAndWait(() -> ourHighlighterFutures.forEach(AsyncHighlighterUpdater::waitForFuture));
        UIUtil.dispatchAllInvocationEvents();
    }

    private static void waitForFuture(Future<?> future2) {
        int iteration = 0;
        while (!future2.isDone() && iteration++ < 1000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                future2.get(10L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        assert (future2.isDone()) : "Too long async highlighter";
    }
}

