/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ObjectUtils;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class LargeFileEditorProvider
extends TextEditorProvider {
    @Override
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        return TextEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        return file2.getFileType().isBinary() ? new LargeBinaryFileEditor(file2) : new LargeTextFileEditor(project2, file2, this);
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "LargeFileEditor";
    }

    private static class LargeBinaryFileEditor
    extends UserDataHolderBase
    implements FileEditor {
        private final VirtualFile myFile;

        LargeBinaryFileEditor(VirtualFile file2) {
            this.myFile = file2;
        }

        @NotNull
        public JComponent getComponent() {
            JLabel label = new JLabel("Binary file " + this.myFile.getPath() + " is too large (" + StringUtil.formatFileSize((long)this.myFile.getLength()) + ")");
            label.setHorizontalAlignment(0);
            return label;
        }

        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public String getName() {
            return "Large file editor";
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            return new TextEditorState();
        }

        public void setState(@NotNull FileEditorState state) {
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public StructureViewBuilder getStructureViewBuilder() {
            return null;
        }

        public void dispose() {
        }
    }

    public static class LargeTextFileEditor
    extends TextEditorImpl {
        LargeTextFileEditor(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider2) {
            super(project2, file2, provider2);
            ObjectUtils.consumeIfCast((Object)this.getEditor(), EditorEx.class, editorEx -> editorEx.setViewer(true));
        }
    }
}

