/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.LargeFileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeFileNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"large.file.editor.notification");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (!(fileEditor instanceof LargeFileEditorProvider.LargeTextFileEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Project project2 = editor.getProject();
        if (project2 == null || editor.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.createActionLabel("Hide notification", () -> {
            editor.putUserData(HIDDEN_KEY, (Object)"true");
            LargeFileNotificationProvider.update(file2, project2);
        });
        panel2.createActionLabel("Don't show again", () -> {
            PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
            LargeFileNotificationProvider.update(file2, project2);
        });
        return panel2.text(String.format("The file is too large: %s. Showing a read-only preview of the first %s.", StringUtil.formatFileSize((long)file2.getLength()), StringUtil.formatFileSize((long)FileUtilRt.LARGE_FILE_PREVIEW_SIZE)));
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project2) {
        EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
    }
}

