/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        return new PsiAwareTextEditorImpl(project2, file2, this);
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        TextEditorState state = (TextEditorState)super.readState(element, project2, file2);
        Element child = element.getChild(FOLDING_ELEMENT);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (child != null) {
            if (document == null) {
                Element detachedStateCopy = child.clone();
                state.setDelayedFoldState((Producer<CodeFoldingState>)((Producer)() -> {
                    Document document1 = FileDocumentManager.getInstance().getCachedDocument(file2);
                    return document1 == null ? null : CodeFoldingManager.getInstance(project2).readFoldingState(detachedStateCopy, document1);
                }));
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).readFoldingState(child, document));
            }
        }
        return state;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        super.writeState(_state, project2, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project2).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException writeExternalException) {
                // empty catch block
            }
            element.addContent(e);
        }
    }

    @Override
    @NotNull
    protected TextEditorState getStateImpl(Project project2, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        TextEditorState state = super.getStateImpl(project2, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project2 != null && !project2.isDisposed() && !editor.isDisposed() && project2.isInitialized()) {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(Project project2, Editor editor, TextEditorState state) {
        super.setStateImpl(project2, editor, state);
        CodeFoldingState foldState = state.getFoldingState();
        if (project2 != null && foldState != null && AsyncEditorLoader.isEditorLoaded(editor)) {
            if (!PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument())) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                LOG.error("File should be parsed when changing editor state, otherwise UI might be frozen for a considerable time");
            }
            editor.getFoldingModel().runBatchFoldingOperation(() -> CodeFoldingManager.getInstance(project2).restoreFoldingState(editor, foldState));
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        return new PsiAwareEditorWrapper(editor);
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            super(editor);
            Project project2 = editor.getProject();
            this.myBackgroundHighlighter = project2 == null ? null : new TextEditorBackgroundHighlighter(project2, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }

        @Override
        public boolean isValid() {
            return !this.getEditor().isDisposed();
        }
    }
}

