/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.EditorHelper;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.InjectedCaret;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorPsiDataProvider
implements EditorDataProvider {
    @Nullable
    public Object getData(@NotNull String dataId, @NotNull Editor e, @NotNull Caret caret) {
        if (e.isDisposed() || !(e instanceof EditorEx)) {
            return null;
        }
        VirtualFile file2 = ((EditorEx)e).getVirtualFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        Project project2 = e.getProject();
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()))) {
            if (project2 == null || PsiDocumentManager.getInstance((Project)project2).isUncommited(e.getDocument())) {
                return e;
            }
            return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(e, caret, TextEditorPsiDataProvider.getPsiFile(e, file2));
        }
        if (LangDataKeys.HOST_EDITOR.is(dataId)) {
            return e instanceof EditorWindow ? ((EditorWindow)e).getDelegate() : e;
        }
        if (LangDataKeys.CARET.is(dataId)) {
            return caret;
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.CARET.getName()))) {
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, caret);
            assert (editor != null);
            return TextEditorPsiDataProvider.getInjectedCaret(editor, caret);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_ELEMENT.getName()))) {
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, caret);
            assert (editor != null);
            Caret injectedCaret = TextEditorPsiDataProvider.getInjectedCaret(editor, caret);
            return TextEditorPsiDataProvider.getPsiElementIn(editor, injectedCaret, file2);
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiElementIn(e, caret, file2);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.LANGUAGE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, caret);
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, caret);
            if (psiFile == null || editor == null) {
                return null;
            }
            Caret injectedCaret = TextEditorPsiDataProvider.getInjectedCaret(editor, caret);
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(injectedCaret, psiFile);
        }
        if (LangDataKeys.LANGUAGE.is(dataId)) {
            PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(e, file2);
            if (psiFile == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(caret, psiFile);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.VIRTUAL_FILE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, caret);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()))) {
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)LangDataKeys.EDITOR.getName()), e, caret);
            if (editor == null) {
                return null;
            }
            if (project2 == null) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        }
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiFile(e, file2);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            PsiDirectory psiDirectory;
            PsiFile psiFile = project2 == null ? null : PsiManager.getInstance((Project)project2).findFile(file2);
            PsiDirectory psiDirectory2 = psiDirectory = psiFile != null ? psiFile.getParent() : null;
            if (psiDirectory != null && (psiDirectory.isPhysical() || ApplicationManager.getApplication().isUnitTestMode())) {
                return new IdeView(){

                    public void selectElement(PsiElement element) {
                        Editor editor = EditorHelper.openInEditor(element);
                        if (editor != null) {
                            ToolWindowManager.getInstance((Project)element.getProject()).activateEditorComponent();
                        }
                    }

                    @NotNull
                    public PsiDirectory[] getDirectories() {
                        return new PsiDirectory[]{psiDirectory};
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }
                };
            }
        }
        if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
            return this.computeLanguages(e, caret);
        }
        return null;
    }

    @NotNull
    private static Caret getInjectedCaret(@NotNull Editor editor, @NotNull Caret hostCaret) {
        if (!(editor instanceof EditorWindow) || hostCaret instanceof InjectedCaret) {
            return hostCaret;
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)caret).getDelegate() != hostCaret) continue;
            return caret;
        }
        throw new IllegalArgumentException("Cannot find injected caret corresponding to " + hostCaret);
    }

    private static Language getLanguageAtCurrentPositionInEditor(Caret caret, PsiFile psiFile) {
        int mostProbablyCorrectLanguageOffset;
        int caretOffset = caret.getOffset();
        int n = mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionStart() || caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        if (caret.hasSelection()) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, mostProbablyCorrectLanguageOffset, caret.getSelectionEnd());
        }
        return PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)mostProbablyCorrectLanguageOffset);
    }

    private static Language getLanguageAtOffset(PsiFile psiFile, int mostProbablyCorrectLanguageOffset, int end) {
        int incremented;
        PsiElement elt = psiFile.findElementAt(mostProbablyCorrectLanguageOffset);
        if (elt == null) {
            return psiFile.getLanguage();
        }
        if (elt instanceof PsiWhiteSpace && (incremented = elt.getTextRange().getEndOffset() + 1) <= end) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, incremented, end);
        }
        return PsiUtilCore.findLanguageFromElement((PsiElement)elt);
    }

    @Nullable
    private static PsiElement getPsiElementIn(@NotNull Editor editor, @NotNull Caret caret, @NotNull VirtualFile file2) {
        PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(editor, file2);
        if (psiFile == null) {
            return null;
        }
        try {
            TargetElementUtil util = TargetElementUtil.getInstance();
            return util.findTargetElement(editor, util.getReferenceSearchFlags(), caret.getOffset());
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Editor e, @NotNull VirtualFile file2) {
        if (!file2.isValid()) {
            return null;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        return psiFile != null && psiFile.isValid() ? psiFile : null;
    }

    private Language[] computeLanguages(@NotNull Editor editor, @NotNull Caret caret) {
        LinkedHashSet set2 = new LinkedHashSet(4);
        Language injectedLanguage = (Language)this.getData(AnActionEvent.injectedId((String)LangDataKeys.LANGUAGE.getName()), editor, caret);
        ContainerUtil.addIfNotNull(set2, (Object)injectedLanguage);
        Language language = (Language)this.getData(LangDataKeys.LANGUAGE.getName(), editor, caret);
        ContainerUtil.addIfNotNull(set2, (Object)language);
        PsiFile psiFile = (PsiFile)this.getData(LangDataKeys.PSI_FILE.getName(), editor, caret);
        if (psiFile != null) {
            ContainerUtil.addIfNotNull(set2, (Object)psiFile.getViewProvider().getBaseLanguage());
        }
        return set2.toArray(new Language[set2.size()]);
    }
}

