/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "file-type";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create(GROUP_ID);
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        FileType[] registeredFileTypes;
        HashSet usedFileTypes = new HashSet();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            throw new CollectUsagesException("Cannot get instance of FileTypeManager");
        }
        for (FileType fileType2 : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project2.isDisposed()) {
                throw new CollectUsagesException("Project is disposed");
            }
            ApplicationManager.getApplication().runReadAction(() -> FileTypeIndex.processFiles(fileType2, (Processor<VirtualFile>)((Processor)file2 -> {
                if (!ProjectKt.getStateStore(project2).isProjectFile((VirtualFile)file2)) {
                    usedFileTypes.add(fileType2);
                    return false;
                }
                return true;
            }), GlobalSearchScope.projectScope((Project)project2)));
        }
        return ContainerUtil.map2Set(usedFileTypes, (Function)((NotNullFunction)fileType -> new UsageDescriptor(fileType.getName(), 1)));
    }
}

