/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ModifierKeyDoubleClickHandler
implements Disposable,
ApplicationComponentAdapter {
    private static final Logger LOG = Logger.getInstance(ModifierKeyDoubleClickHandler.class);
    private static final TIntIntHashMap KEY_CODE_TO_MODIFIER_MAP = new TIntIntHashMap();
    private final ActionManagerEx myActionManagerEx;
    private final ConcurrentMap<String, MyDispatcher> myDispatchers = ContainerUtil.newConcurrentMap();
    private boolean myIsRunningAction;

    private ModifierKeyDoubleClickHandler(ActionManagerEx actionManagerEx) {
        this.myActionManagerEx = actionManagerEx;
    }

    public void initComponent() {
        int modifierKeyCode = ModifierKeyDoubleClickHandler.getMultiCaretActionModifier();
        this.registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
        this.registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
        this.registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
        this.registerAction("EditorRightWithSelection", modifierKeyCode, 39);
        this.registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
        this.registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
    }

    public void dispose() {
        for (MyDispatcher dispatcher : this.myDispatchers.values()) {
            Disposer.dispose((Disposable)dispatcher);
        }
        this.myDispatchers.clear();
    }

    public static ModifierKeyDoubleClickHandler getInstance() {
        return (ModifierKeyDoubleClickHandler)ApplicationManager.getApplication().getComponent(ModifierKeyDoubleClickHandler.class);
    }

    public static int getMultiCaretActionModifier() {
        return SystemInfo.isMac ? 18 : 17;
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
        MyDispatcher dispatcher = new MyDispatcher(actionId, modifierKeyCode, actionKeyCode, skipIfActionHasShortcut);
        MyDispatcher oldDispatcher = this.myDispatchers.put(actionId, dispatcher);
        IdeEventQueue.getInstance().addDispatcher(dispatcher, dispatcher);
        this.myActionManagerEx.addAnActionListener((AnActionListener)dispatcher, (Disposable)dispatcher);
        if (oldDispatcher != null) {
            Disposer.dispose((Disposable)oldDispatcher);
        }
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
        this.registerAction(actionId, modifierKeyCode, actionKeyCode, true);
    }

    public void unregisterAction(@NotNull String actionId) {
        MyDispatcher oldDispatcher = (MyDispatcher)this.myDispatchers.remove(actionId);
        if (oldDispatcher != null) {
            Disposer.dispose((Disposable)oldDispatcher);
        }
    }

    public boolean isRunningAction() {
        return this.myIsRunningAction;
    }

    static {
        KEY_CODE_TO_MODIFIER_MAP.put(18, 8);
        KEY_CODE_TO_MODIFIER_MAP.put(17, 2);
        KEY_CODE_TO_MODIFIER_MAP.put(157, 4);
        KEY_CODE_TO_MODIFIER_MAP.put(16, 1);
    }

    private class MyDispatcher
    extends AnActionListener.Adapter
    implements IdeEventQueue.EventDispatcher,
    Disposable {
        private final String myActionId;
        private final int myModifierKeyCode;
        private final int myActionKeyCode;
        private final boolean mySkipIfActionHasShortcut;
        private final Couple<AtomicBoolean> ourPressed = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
        private final Couple<AtomicBoolean> ourReleased = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
        private final AtomicBoolean ourOtherKeyWasPressed = new AtomicBoolean(false);
        private final AtomicLong ourLastTimePressed = new AtomicLong(0L);

        public MyDispatcher(String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
            this.myActionId = actionId;
            this.myModifierKeyCode = modifierKeyCode;
            this.myActionKeyCode = actionKeyCode;
            this.mySkipIfActionHasShortcut = skipIfActionHasShortcut;
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                int keyCode = keyEvent.getKeyCode();
                LOG.debug("", new Object[]{this, event});
                if (keyCode == this.myModifierKeyCode) {
                    if (this.hasOtherModifiers(keyEvent)) {
                        this.resetState();
                        return false;
                    }
                    if (this.myActionKeyCode == -1 && this.ourOtherKeyWasPressed.get() && Clock.getTime() - this.ourLastTimePressed.get() < 500L) {
                        this.resetState();
                        return false;
                    }
                    this.ourOtherKeyWasPressed.set(false);
                    if (((AtomicBoolean)this.ourPressed.first).get() && Clock.getTime() - this.ourLastTimePressed.get() > 500L) {
                        this.resetState();
                    }
                    this.handleModifier((KeyEvent)event);
                    return false;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get() && this.myActionKeyCode != -1) {
                    if (keyCode == this.myActionKeyCode && !this.hasOtherModifiers(keyEvent)) {
                        if (event.getID() == 401) {
                            return this.run(keyEvent);
                        }
                        return true;
                    }
                    return false;
                }
                this.ourLastTimePressed.set(Clock.getTime());
                this.ourOtherKeyWasPressed.set(true);
                if (keyCode == 27 || keyCode == 9) {
                    this.ourLastTimePressed.set(0L);
                }
                this.resetState();
            }
            return false;
        }

        private boolean hasOtherModifiers(KeyEvent keyEvent) {
            final int modifiers = keyEvent.getModifiers();
            return !KEY_CODE_TO_MODIFIER_MAP.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int keyCode, int modifierMask) {
                    return keyCode == MyDispatcher.this.myModifierKeyCode || (modifiers & modifierMask) == 0;
                }
            });
        }

        private void handleModifier(KeyEvent event) {
            if (((AtomicBoolean)this.ourPressed.first).get() && Clock.getTime() - this.ourLastTimePressed.get() > 300L) {
                this.resetState();
                return;
            }
            if (event.getID() == 401) {
                if (!((AtomicBoolean)this.ourPressed.first).get()) {
                    this.resetState();
                    ((AtomicBoolean)this.ourPressed.first).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourPressed.second).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
            } else if (event.getID() == 402) {
                if (((AtomicBoolean)this.ourPressed.first).get() && !((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourReleased.first).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get()) {
                    this.resetState();
                    if (this.myActionKeyCode == -1 && !this.shouldSkipIfActionHasShortcut()) {
                        this.run(event);
                    }
                    return;
                }
            }
            this.resetState();
        }

        private void resetState() {
            ((AtomicBoolean)this.ourPressed.first).set(false);
            ((AtomicBoolean)this.ourPressed.second).set(false);
            ((AtomicBoolean)this.ourReleased.first).set(false);
            ((AtomicBoolean)this.ourReleased.second).set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean run(KeyEvent event) {
            ModifierKeyDoubleClickHandler.this.myIsRunningAction = true;
            try {
                AnAction action = ModifierKeyDoubleClickHandler.this.myActionManagerEx.getAction(this.myActionId);
                if (action == null) {
                    boolean bl = false;
                    return bl;
                }
                DataContext context = DataManager.getInstance().getDataContext(IdeFocusManager.findInstance().getFocusOwner());
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)event, (String)"MainMenu", (DataContext)context);
                action.update(anActionEvent);
                if (!anActionEvent.getPresentation().isEnabled()) {
                    boolean bl = false;
                    return bl;
                }
                ModifierKeyDoubleClickHandler.this.myActionManagerEx.fireBeforeActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
                action.actionPerformed(anActionEvent);
                ModifierKeyDoubleClickHandler.this.myActionManagerEx.fireAfterActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
                boolean bl = true;
                return bl;
            }
            finally {
                ModifierKeyDoubleClickHandler.this.myIsRunningAction = false;
            }
        }

        private boolean shouldSkipIfActionHasShortcut() {
            return this.mySkipIfActionHasShortcut && KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.myActionId).length > 0;
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!ModifierKeyDoubleClickHandler.this.myIsRunningAction) {
                this.resetState();
            }
        }

        public void dispose() {
        }

        public String toString() {
            return "modifier double-click dispatcher [modifierKeyCode=" + this.myModifierKeyCode + ",actionKeyCode=" + this.myActionKeyCode + ",actionId=" + this.myActionId + "]";
        }
    }
}

