/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.JavaPsiFacade;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaModuleType
extends ModuleType<JavaModuleBuilder> {
    public static final String MODULE_NAME = ProjectBundle.message((String)"module.type.java.name", (Object[])new Object[0]);
    public static final String JAVA_GROUP = "Java";
    public static final String BUILD_TOOLS_GROUP = "Build Tools";
    private static final String JAVA_MODULE = "JAVA_MODULE";

    public static ModuleType getModuleType() {
        return ModuleTypeManager.getInstance().findByID(JAVA_MODULE);
    }

    public JavaModuleType() {
        this(JAVA_MODULE);
    }

    protected JavaModuleType(@NonNls String id) {
        super(id);
    }

    @NotNull
    public JavaModuleBuilder createModuleBuilder() {
        return new JavaModuleBuilder();
    }

    @NotNull
    public String getName() {
        return MODULE_NAME;
    }

    @NotNull
    public String getDescription() {
        return ProjectBundle.message((String)"module.type.java.description", (Object[])new Object[0]);
    }

    public Icon getBigIcon() {
        return JavaModuleType.getJavaModuleIcon();
    }

    public Icon getNodeIcon(boolean isOpened) {
        return JavaModuleType.getJavaModuleNodeIconClosed();
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        return ProjectWizardStepFactory.getInstance().createJavaSettingsStep(settingsStep, moduleBuilder, arg_0 -> ((ModuleBuilder)moduleBuilder).isSuitableSdkType(arg_0));
    }

    private static Icon getJavaModuleIcon() {
        return AllIcons.Modules.Types.JavaModule;
    }

    private static Icon getJavaModuleNodeIconClosed() {
        return AllIcons.Nodes.Module;
    }

    public boolean isValidSdk(@NotNull Module module2, Sdk projectSdk) {
        return JavaModuleType.isValidJavaSdk(module2);
    }

    public static boolean isValidJavaSdk(@NotNull Module module2) {
        if (ModuleRootManager.getInstance((Module)module2).getSourceRoots(JavaModuleSourceRootTypes.SOURCES).isEmpty()) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass("java.lang.Object", module2.getModuleWithLibrariesScope()) != null;
    }
}

