/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.util.LazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeImporterEP<S extends Scheme>
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<SchemeImporterEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.schemeImporter");
    @Attribute(value="name")
    public String name;
    @Attribute(value="schemeClass")
    public String schemeClass;
    @Attribute(value="implementationClass")
    public String implementationClass;
    private final LazyInstance<SchemeImporter<S>> myImporterInstance = new LazyInstance<SchemeImporter<S>>(){

        protected Class<SchemeImporter<S>> getInstanceClass() throws ClassNotFoundException {
            return SchemeImporterEP.this.findClass(SchemeImporterEP.this.implementationClass);
        }
    };

    public SchemeImporter<S> getInstance() {
        return (SchemeImporter)this.myImporterInstance.getValue();
    }

    @NotNull
    public static <S extends Scheme> Collection<SchemeImporterEP<S>> getExtensions(Class<S> schemeClass) {
        ArrayList<SchemeImporterEP<S>> importers = new ArrayList<SchemeImporterEP<S>>();
        for (SchemeImporterEP importerEP : (SchemeImporterEP[])EP_NAME.getExtensions()) {
            if (!schemeClass.getName().equals(importerEP.schemeClass)) continue;
            importers.add(importerEP);
        }
        return importers;
    }

    @Nullable
    public static <S extends Scheme> SchemeImporter<S> getImporter(@NotNull String name, Class<S> schemeClass) {
        for (SchemeImporterEP<S> importerEP : SchemeImporterEP.getExtensions(schemeClass)) {
            if (!name.equals(importerEP.name)) continue;
            return importerEP.getInstance();
        }
        return null;
    }
}

