/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.util.Condition;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemeManager<T extends Scheme> {
    public static final String EDITABLE_COPY_PREFIX = "_@user_";

    @NotNull
    public abstract Collection<T> loadSchemes();

    public void reload() {
    }

    public abstract void addNewScheme(@NotNull T var1, boolean var2);

    public void addScheme(@NotNull T scheme2) {
        this.addNewScheme(scheme2, true);
    }

    public abstract void clearAllSchemes();

    @NotNull
    public abstract List<T> getAllSchemes();

    public boolean isEmpty() {
        return this.getAllSchemes().isEmpty();
    }

    @Nullable
    public abstract T findSchemeByName(@NotNull String var1);

    public final void setCurrentSchemeName(@Nullable String schemeName) {
        this.setCurrentSchemeName(schemeName, true);
    }

    public abstract void setCurrentSchemeName(@Nullable String var1, boolean var2);

    public final void setCurrent(@Nullable T scheme2) {
        this.setCurrent(scheme2, true);
    }

    public void setCurrent(@Nullable T scheme2, boolean notify) {
        this.setCurrentSchemeName(scheme2 == null ? null : scheme2.getName());
    }

    @Nullable
    public abstract T getCurrentScheme();

    @Nullable
    public String getCurrentSchemeName() {
        T scheme2 = this.getCurrentScheme();
        return scheme2 == null ? null : scheme2.getName();
    }

    public abstract boolean removeScheme(@NotNull T var1);

    @Nullable
    public T removeScheme(@NotNull String name) {
        T scheme2 = this.findSchemeByName(name);
        if (scheme2 != null) {
            this.removeScheme(scheme2);
            return scheme2;
        }
        return null;
    }

    @NotNull
    public abstract Collection<String> getAllSchemeNames();

    public abstract File getRootDirectory();

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor) {
    }

    public final void setSchemes(@NotNull List<T> newSchemes) {
        this.setSchemes(newSchemes, null, null);
    }

    public final void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme) {
        this.setSchemes(newSchemes, newCurrentScheme, null);
    }

    public void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
    }

    public boolean isMetadataEditable(@NotNull T scheme2) {
        return true;
    }

    public static String getDisplayName(@NotNull Scheme scheme2) {
        String schemeName = scheme2.getName();
        return schemeName.startsWith(EDITABLE_COPY_PREFIX) ? schemeName.substring(EDITABLE_COPY_PREFIX.length()) : schemeName;
    }
}

