/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorPalette;
import com.intellij.openapi.editor.colors.EditorColorPaletteFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorPaletteFactoryImpl
extends EditorColorPaletteFactory {
    public EditorColorPalette getPalette(@NotNull EditorColorsScheme scheme2, @Nullable Language language) {
        return new ColorPagesPalette(scheme2, language);
    }

    private static class ColorPagesPalette
    extends EditorColorPalette {
        @Nullable
        private Language myLanguage;

        public ColorPagesPalette(@NotNull EditorColorsScheme colorsScheme, @Nullable Language language) {
            super(colorsScheme);
            this.myLanguage = language;
        }

        protected Collection<TextAttributesKey> getTextAttributeKeys() {
            HashSet<TextAttributesKey> textAttributesKeys = new HashSet<TextAttributesKey>();
            for (ColorSettingsPage page : ColorSettingsPages.getInstance().getRegisteredPages()) {
                Language pageLanguage = ColorPagesPalette.guessPageLanguage(page);
                if ((this.myLanguage != null || pageLanguage != null) && (this.myLanguage == null || !this.myLanguage.is(pageLanguage) && !this.myLanguage.is(Language.ANY))) continue;
                for (AttributesDescriptor descriptor : page.getAttributeDescriptors()) {
                    textAttributesKeys.add(descriptor.getKey());
                }
            }
            return textAttributesKeys;
        }

        @Nullable
        private static Language guessPageLanguage(@NotNull ColorSettingsPage page) {
            for (Language language : Language.getRegisteredLanguages()) {
                if ((!(page instanceof RainbowColorSettingsPage) || !language.is(((RainbowColorSettingsPage)page).getLanguage())) && !page.getDisplayName().equals(language.getDisplayName())) continue;
                return language;
            }
            return null;
        }
    }
}

