/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableVisitor {
    public static final ConfigurableVisitor ALL = new ConfigurableVisitor(){

        @Override
        protected boolean accept(Configurable configurable) {
            return true;
        }
    };

    protected abstract boolean accept(Configurable var1);

    public final Configurable find(ConfigurableGroup ... groups) {
        for (ConfigurableGroup group : groups) {
            Configurable result2 = this.find(group.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public final Configurable find(Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            if (!this.accept(configurable)) continue;
            return configurable;
        }
        for (Configurable configurable : configurables) {
            Configurable.Composite composite;
            Configurable result2;
            if (!(configurable instanceof Configurable.Composite) || (result2 = this.find((composite = (Configurable.Composite)configurable).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    public final List<Configurable> findAll(ConfigurableGroup ... groups) {
        ArrayList<Configurable> list = new ArrayList<Configurable>();
        for (ConfigurableGroup group : groups) {
            this.add(list, group.getConfigurables());
        }
        return list;
    }

    public final List<Configurable> findAll(Configurable ... configurables) {
        ArrayList<Configurable> list = new ArrayList<Configurable>();
        this.add(list, configurables);
        return list;
    }

    private void add(List<Configurable> list, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            if (this.accept(configurable)) {
                list.add(configurable);
            }
            if (!(configurable instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable;
            this.add(list, composite.getConfigurables());
        }
    }

    public static final class ByType
    extends ConfigurableVisitor {
        private final Class<? extends Configurable> myType;

        public ByType(@NotNull Class<? extends Configurable> type2) {
            this.myType = type2;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return ConfigurableWrapper.cast(this.myType, (UnnamedConfigurable)configurable) != null;
        }
    }

    public static final class ByName
    extends ConfigurableVisitor {
        private final String myName;

        public ByName(@NotNull String name) {
            this.myName = name;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myName.equals(configurable.getDisplayName());
        }
    }

    public static final class ByID
    extends ConfigurableVisitor {
        private final String myID;

        public ByID(@NotNull String id) {
            this.myID = id;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myID.equals(ByID.getID(configurable));
        }

        public static String getID(Configurable configurable) {
            return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getId() : configurable.getClass().getName();
        }
    }
}

