/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class Banner
extends JPanel {
    private final JPanel myLeftPanel = new JPanel(null);
    private final JLabel myProjectIcon = new JLabel();

    Banner(Action action) {
        super(new BorderLayout(10, 0));
        this.myLeftPanel.setLayout((LayoutManager)new HorizontalLayout(5));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurableBanner);
        this.myProjectIcon.setForeground((Color)JBColor.GRAY);
        this.myProjectIcon.setVisible(false);
        this.add("West", this.myLeftPanel);
        this.add("Center", this.myProjectIcon);
        this.add("East", RelativeFont.BOLD.install((Component)new SwingActionLink(action)));
    }

    void setText(String ... names) {
        Component[] components;
        for (Component component : components = this.myLeftPanel.getComponents()) {
            component.setVisible(false);
        }
        if (names != null) {
            int i2 = 0;
            for (String name : names) {
                if (i2 < components.length) {
                    if (i2 > 0) {
                        components[i2 - 1].setVisible(true);
                    }
                    components[i2].setVisible(true);
                    if (components[i2] instanceof JLabel) {
                        ((JLabel)components[i2]).setText(name);
                    }
                } else {
                    if (i2 > 0) {
                        this.myLeftPanel.add(RelativeFont.HUGE.install((Component)new JLabel("\u203a")));
                    }
                    this.myLeftPanel.add(RelativeFont.BOLD.install((Component)new JLabel(name)));
                }
                i2 += 2;
            }
        }
    }

    void setProject(Project project2) {
        if (project2 == null) {
            this.myProjectIcon.setVisible(false);
        } else {
            this.myProjectIcon.setVisible(true);
            this.myProjectIcon.setText(OptionsBundle.message((String)(project2.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
        }
    }
}

