/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project2, String key2, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(project2, true);
        this.myDimensionServiceKey = key2;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, project2);
    }

    public SettingsDialog(@NotNull Component parent, String key2, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(parent, true);
        this.myDimensionServiceKey = key2;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project2, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter) {
        super(project2, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project2, groups, configurable, filter, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project2);
    }

    protected SettingsTreeView treeViewFactory(SettingsFilter filter, ConfigurableGroup[] groups) {
        return new SettingsTreeView(filter, groups);
    }

    public void show() {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> super.show());
    }

    private void init(Configurable configurable, @Nullable Project project2) {
        String name = configurable == null ? null : configurable.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project2 != null && project2.isDefault()) {
            title = "Default " + title;
        }
        this.setTitle(name == null ? title : name.replace('\n', ' '));
        this.init();
    }

    public Object getData(@NonNls String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider2 = (DataProvider)this.myEditor;
            return provider2.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.myEditor instanceof SettingsEditor) {
            ((SettingsEditor)this.myEditor).addOptionsListener(colleague);
        }
    }

    @NotNull
    protected Action[] createActions() {
        String topic;
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.myEditor.getApplyAction();
        if (apply2 != null && this.myApplyButtonNeeded) {
            actions.add(apply2);
        }
        if ((reset = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset);
        }
        if ((topic = this.getHelpTopic()) != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected String getHelpTopic() {
        return this.myEditor.getHelpTopic();
    }

    protected void doHelpAction() {
        String topic = this.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public void doOKAction() {
        if (this.myEditor.apply()) {
            ApplicationManager.getApplication().saveAll();
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }
}

