/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceManagerImpl
extends PathReferenceManager {
    private final StaticPathReferenceProvider myStaticProvider = new StaticPathReferenceProvider(null);
    private final PathReferenceProvider myGlobalPathsProvider = new GlobalPathReferenceProvider();
    private static final Comparator<PsiReference> START_OFFSET_COMPARATOR = (o1, o2) -> o1.getRangeInElement().getStartOffset() - o2.getRangeInElement().getStartOffset();

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element, PathReferenceProvider ... additionalProviders) {
        PathReference pathReference;
        for (PathReferenceProvider provider2 : PathReferenceManagerImpl.getProviders()) {
            pathReference = provider2.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        for (PathReferenceProvider provider2 : additionalProviders) {
            pathReference = provider2.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        pathReference = this.myStaticProvider.getPathReference(path, element);
        if (pathReference != null) {
            return pathReference;
        }
        return null;
    }

    @Nullable
    public PathReference getCustomPathReference(@NotNull String path, @NotNull Module module2, @NotNull PsiElement element, PathReferenceProvider ... providers) {
        for (PathReferenceProvider provider2 : providers) {
            PathReference reference = provider2.getPathReference(path, element);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    @NotNull
    public PathReferenceProvider getGlobalWebPathReferenceProvider() {
        return this.myGlobalPathsProvider;
    }

    @NotNull
    public PathReferenceProvider createStaticPathReferenceProvider(boolean relativePathsAllowed) {
        StaticPathReferenceProvider provider2 = new StaticPathReferenceProvider(null);
        provider2.setRelativePathsAllowed(relativePathsAllowed);
        return provider2;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, PathReferenceProvider ... additionalProviders) {
        return this.createReferences(psiElement, soft, endingSlashNotAllowed, relativePathsAllowed, (FileType[])null, additionalProviders);
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, FileType[] suitableFileTypes, PathReferenceProvider ... additionalProviders) {
        ArrayList<PsiReference> mergedReferences = new ArrayList<PsiReference>();
        PathReferenceManagerImpl.processProvider(psiElement, this.myGlobalPathsProvider, mergedReferences, soft);
        StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(suitableFileTypes);
        staticProvider.setEndingSlashNotAllowed(endingSlashNotAllowed);
        staticProvider.setRelativePathsAllowed(relativePathsAllowed);
        PathReferenceManagerImpl.processProvider(psiElement, staticProvider, mergedReferences, soft);
        for (PathReferenceProvider provider2 : PathReferenceManagerImpl.getProviders()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider2, mergedReferences, soft);
        }
        for (PathReferenceProvider provider2 : additionalProviders) {
            PathReferenceManagerImpl.processProvider(psiElement, provider2, mergedReferences, soft);
        }
        for (PathReferenceProvider provider2 : (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)ANCHOR_REFERENCE_PROVIDER_EP)) {
            PathReferenceManagerImpl.processProvider(psiElement, provider2, mergedReferences, soft);
        }
        return PathReferenceManagerImpl.mergeReferences(psiElement, mergedReferences);
    }

    @NotNull
    public PsiReference[] createCustomReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... providers) {
        PathReferenceProvider provider2;
        boolean processed2;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        PathReferenceProvider[] pathReferenceProviderArray = providers;
        int n = pathReferenceProviderArray.length;
        for (int j = 0; j < n && !(processed2 = PathReferenceManagerImpl.processProvider(psiElement, provider2 = pathReferenceProviderArray[j], references, soft)); ++j) {
        }
        return PathReferenceManagerImpl.mergeReferences(psiElement, references);
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... additionalProviders) {
        return this.createReferences(psiElement, soft, false, true, (FileType[])null, additionalProviders);
    }

    private static PsiReference[] mergeReferences(PsiElement element, List<PsiReference> references) {
        if (references.size() <= 1) {
            return references.toArray(new PsiReference[references.size()]);
        }
        Collections.sort(references, START_OFFSET_COMPARATOR);
        ArrayList<PsiReference> intersecting = new ArrayList<PsiReference>();
        ArrayList<PsiReference> notIntersecting = new ArrayList<PsiReference>();
        TextRange intersectingRange = references.get(0).getRangeInElement();
        boolean intersected = false;
        for (int i2 = 1; i2 < references.size(); ++i2) {
            PsiReference reference = references.get(i2);
            TextRange range = reference.getRangeInElement();
            int offset = range.getStartOffset();
            if (intersectingRange.getStartOffset() <= offset && intersectingRange.getEndOffset() >= offset) {
                intersected = true;
                intersecting.add(references.get(i2 - 1));
                if (i2 == references.size() - 1) {
                    intersecting.add(reference);
                }
                intersectingRange = intersectingRange.union(range);
                continue;
            }
            if (intersected) {
                intersecting.add(references.get(i2 - 1));
                intersected = false;
            } else {
                notIntersecting.add(references.get(i2 - 1));
            }
            intersectingRange = range;
            if (i2 != references.size() - 1) continue;
            notIntersecting.add(reference);
        }
        List<PsiReference> result2 = PathReferenceManagerImpl.doMerge(element, intersecting);
        result2.addAll(notIntersecting);
        return result2.toArray(new PsiReference[result2.size()]);
    }

    private static List<PsiReference> doMerge(PsiElement element, List<PsiReference> references) {
        TextRange range;
        SmartList list;
        ArrayList<PsiReference> resolvingRefs = new ArrayList<PsiReference>();
        ArrayList<PsiReference> nonResolvingRefs = new ArrayList<PsiReference>();
        for (int i2 = 0; i2 < references.size(); ++i2) {
            PsiReference reference = references.get(i2);
            assert (element.equals(reference.getElement()));
            if (reference.resolve() != null) {
                resolvingRefs.add(reference);
                continue;
            }
            nonResolvingRefs.add(reference);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>(5);
        while (!resolvingRefs.isEmpty()) {
            list = new ArrayList(5);
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(resolvingRefs, (List<PsiReference>)list);
            TextRange textRange = PathReferenceManagerImpl.addIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list, range);
            PathReferenceManagerImpl.addToResult(element, result2, (List<PsiReference>)list, textRange);
        }
        while (!nonResolvingRefs.isEmpty()) {
            list = new SmartList();
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list);
            int endOffset = range.getEndOffset();
            for (PsiReference reference : list) {
                endOffset = Math.min(endOffset, reference.getRangeInElement().getEndOffset());
            }
            PathReferenceManagerImpl.addToResult(element, result2, (List<PsiReference>)list, new TextRange(range.getStartOffset(), endOffset));
        }
        return result2;
    }

    private static void addToResult(PsiElement element, List<PsiReference> result2, List<PsiReference> list, TextRange range) {
        if (list.size() == 1) {
            result2.add(list.get(0));
        } else {
            PsiDynaReference<PsiElement> psiDynaReference = new PsiDynaReference<PsiElement>(element);
            psiDynaReference.addReferences(list);
            psiDynaReference.setRangeInElement(range);
            result2.add((PsiReference)psiDynaReference);
        }
    }

    private static TextRange addIntersectingReferences(List<PsiReference> set2, List<PsiReference> toAdd, TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getStartOffset();
        Iterator<PsiReference> iterator = set2.iterator();
        while (iterator.hasNext()) {
            PsiReference reference = iterator.next();
            TextRange rangeInElement = reference.getRangeInElement();
            if (!PathReferenceManagerImpl.intersect(range, rangeInElement)) continue;
            toAdd.add(reference);
            iterator.remove();
            startOffset = Math.min(startOffset, rangeInElement.getStartOffset());
            endOffset = Math.max(endOffset, rangeInElement.getEndOffset());
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean intersect(TextRange range1, TextRange range2) {
        return range2.intersectsStrict(range1) || range2.intersects(range1) && (range1.isEmpty() || range2.isEmpty());
    }

    private static TextRange getFirstIntersectingReferences(List<PsiReference> set2, List<PsiReference> toAdd) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        Iterator<PsiReference> it = set2.iterator();
        while (it.hasNext()) {
            PsiReference reference = it.next();
            TextRange range = reference.getRangeInElement();
            if (endOffset != -1 && range.getStartOffset() > endOffset) break;
            startOffset = Math.min(startOffset, range.getStartOffset());
            endOffset = Math.max(range.getEndOffset(), endOffset);
            toAdd.add(reference);
            it.remove();
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean processProvider(PsiElement psiElement, PathReferenceProvider provider2, List<PsiReference> mergedReferences, boolean soft) {
        return provider2.createReferences(psiElement, mergedReferences, soft);
    }

    private static PathReferenceProvider[] getProviders() {
        return (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)PATH_REFERENCE_PROVIDER_EP);
    }
}

