/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private int myChosenOne = -1;
    private ResolveResult[] myCachedResult;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<PsiReference> references) {
        this.myReferences.addAll(references);
        for (PsiReference reference : references) {
            if (reference.isSoft()) continue;
            this.mySoft = false;
        }
    }

    public List<PsiReference> getReferences() {
        return this.myReferences;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
        if (!reference.isSoft()) {
            this.mySoft = false;
        }
    }

    public TextRange getRangeInElement() {
        PsiReference resolved = null;
        PsiReference reference = this.myReferences.get(0);
        if (reference.resolve() != null) {
            resolved = reference;
        }
        TextRange range = reference.getRangeInElement();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        for (int i2 = 1; i2 < this.myReferences.size(); ++i2) {
            reference = this.myReferences.get(i2);
            TextRange textRange = this.getRange(reference);
            start = Math.min(start, textRange.getStartOffset());
            if (resolved != null) continue;
            end = Math.max(end, textRange.getEndOffset());
        }
        return new TextRange(start, end);
    }

    private TextRange getRange(PsiReference reference) {
        TextRange rangeInElement = reference.getRangeInElement();
        PsiElement element = reference.getElement();
        while (element != this.myElement) {
            rangeInElement = rangeInElement.shiftRight(element.getStartOffsetInParent());
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return rangeInElement;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        PsiReference reference = this.chooseReference();
        return reference == null ? this.myReferences.get(0).getCanonicalText() : reference.getCanonicalText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiReference reference = this.chooseReference();
        if (reference != null) {
            return reference.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReference)) continue;
            return reference.bindToElement(element);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (PsiReference reference : this.myReferences) {
            if (reference instanceof PsiPolyVariantReference) {
                for (ResolveResult rr : ((PsiPolyVariantReference)reference).multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result2.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            result2.add(new PsiElementResolveResult(resolved));
        }
        return result2.toArray(new ResolveResult[result2.size()]);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myChosenOne != -1) {
            return this.myReferences.get(this.myChosenOne);
        }
        boolean flag = false;
        for (int i2 = 0; i2 < this.myReferences.size(); ++i2) {
            PsiReference reference = this.myReferences.get(i2);
            if (reference.isSoft() && flag) continue;
            if (!reference.isSoft() && !flag) {
                this.myChosenOne = i2;
                flag = true;
                continue;
            }
            if (reference.resolve() == null) continue;
            this.myChosenOne = i2;
        }
        return this.myChosenOne >= 0 ? this.myReferences.get(this.myChosenOne) : null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiReference reference = this.chooseReference();
        return reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList list = new ArrayList();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            ContainerUtil.addAll(list, (Object[])((LocalQuickFixProvider)ref).getQuickFixes());
        }
        return list.toArray(new LocalQuickFix[list.size()]);
    }

    public String toString() {
        return "PsiDynaReference containing " + this.myReferences.toString();
    }

    @Override
    public PsiFileReference getLastFileReference() {
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReferenceOwner)) continue;
            return ((FileReferenceOwner)reference).getLastFileReference();
        }
        return null;
    }
}

