/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview;

import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewInfo<V, C> {
    @NotNull
    private final PreviewPanelProvider<V, C> myProvider;
    @NotNull
    private final V myData;

    public static <V, C> PreviewInfo<V, C> create(@NotNull PreviewPanelProvider<V, C> provider2, @NotNull V data) {
        return new PreviewInfo<V, C>(provider2, data);
    }

    public PreviewInfo(@NotNull PreviewPanelProvider<V, C> provider2, @NotNull V data) {
        this.myProvider = provider2;
        this.myData = data;
    }

    public PreviewProviderId<V, C> getId() {
        return this.myProvider.getId();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myProvider.getComponent();
    }

    @NotNull
    public String getTitle() {
        return this.myProvider.getTitle(this.myData);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myProvider.getIcon(this.myData);
        return icon != null ? icon : EmptyIcon.ICON_16;
    }

    @NotNull
    public PreviewPanelProvider<V, C> getProvider() {
        return this.myProvider;
    }

    @NotNull
    public V getData() {
        return this.myData;
    }

    @Nullable
    public C initComponent(boolean requestFocus) {
        return this.myProvider.initComponent(this.myData, requestFocus);
    }

    public boolean isModified(boolean beforeReuse) {
        return this.myProvider.isModified(this.myData, beforeReuse);
    }

    public int hashCode() {
        return this.myProvider.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PreviewInfo)) {
            return false;
        }
        return ((PreviewInfo)obj).getId() == this.getId() && this.myProvider.contentsAreEqual(((PreviewInfo)obj).myData, this.myData);
    }

    public void release() {
        this.myProvider.release(this.myData);
    }

    public boolean supportsStandardPlace() {
        return this.myProvider.supportsStandardPlace();
    }
}

