/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private final Set<PotemkinProgress> myEdtProgresses = ContainerUtil.newConcurrentSet();

    @Override
    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginalProgressIndicator()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        boolean edtProgress;
        if (progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        boolean bl = edtProgress = progress instanceof PotemkinProgress && ApplicationManager.getApplication().isDispatchThread();
        if (edtProgress) {
            this.myEdtProgresses.add((PotemkinProgress)progress);
        }
        try {
            super.executeProcessUnderProgress(process2, progress);
        }
        finally {
            if (progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
            if (edtProgress) {
                this.myEdtProgresses.remove(progress);
            }
        }
    }

    public static void runWithAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task, @Nullable JComponent parentComponent) {
        long start = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        return this.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator, null);
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final CoreProgressManager.TaskRunnable process2 = new CoreProgressManager.TaskRunnable((Task)task, progressIndicator, continuation);
        CoreProgressManager.TaskContainer action = new CoreProgressManager.TaskContainer((Task)task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                long end = System.currentTimeMillis();
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.notifyFinished();
                    long time = end - start;
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> CoreProgressManager.finishTask((Task)task, finalCanceled, finalException), modalityState);
            }
        };
        return ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new AssertionError((Object)"runInReadActionWithWriteActionPriority shouldn't be invoked from read action");
        }
        boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action);
        if (!success) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return success;
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        boolean hasEdtProgresses;
        boolean shouldSleep = HeavyProcessLatch.INSTANCE.hasPrioritizedThread() && Registry.is((String)"ide.prioritize.ui.thread", (boolean)false);
        boolean bl = hasEdtProgresses = !this.myEdtProgresses.isEmpty();
        if (shouldSleep && hasEdtProgresses) {
            return () -> this.pingProgresses() | ProgressManagerImpl.sleepIfNeededToGivePriorityToAnotherThread();
        }
        if (shouldSleep) {
            return ProgressManagerImpl::sleepIfNeededToGivePriorityToAnotherThread;
        }
        if (hasEdtProgresses) {
            return this::pingProgresses;
        }
        return null;
    }

    private boolean pingProgresses() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        boolean hasProgresses = false;
        for (PotemkinProgress progress : this.myEdtProgresses) {
            hasProgresses = true;
            progress.interact();
        }
        return hasProgresses;
    }

    private static boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (HeavyProcessLatch.INSTANCE.isInsideLowPriorityThread()) {
            LockSupport.parkNanos(1000000L);
            return true;
        }
        return false;
    }
}

