/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DoubleArrayList;
import com.intellij.util.containers.Stack;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate;
    private volatile Object myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    private Stack<String> myTextStack;
    private DoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    private volatile int myNonCancelableCount;
    protected ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), (Object)"Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.startSystemActivity();
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    public synchronized void stop() {
        this.myRunning = false;
        this.myFinished = true;
        this.stopSystemActivity();
    }

    protected void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo((String)this.toString()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSystemActivity() {
        if (this.myMacActivity != null) {
            Object object = this.myMacActivity;
            synchronized (object) {
                MacUtil.matrixHasYou((Object)this.myMacActivity);
                this.myMacActivity = null;
            }
        }
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled((ProgressIndicator)this);
        }
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    public void checkCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            throw new ProcessCanceledException();
        }
        if (CoreProgressManager.runCheckCanceledHooks() && this.isCanceled() && this.isCancelable()) {
            throw new ProcessCanceledException();
        }
    }

    public void setText(String text) {
        this.myText = text;
    }

    public String getText() {
        return this.myText;
    }

    public void setText2(String text) {
        this.myText2 = text;
    }

    public String getText2() {
        return this.myText2;
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(double fraction) {
        this.myFraction = fraction;
    }

    public synchronized void pushState() {
        this.getTextStack().push((Object)this.myText);
        this.getFractionStack().add(this.myFraction);
        this.getText2Stack().push((Object)this.myText2);
    }

    public synchronized void popState() {
        LOG.assertTrue(!this.myTextStack.isEmpty());
        String oldText = (String)this.myTextStack.pop();
        double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
        String oldText2 = (String)this.myText2Stack.pop();
        this.setText(oldText);
        this.setFraction(oldFraction);
        this.setText2(oldText2);
    }

    public void startNonCancelableSection() {
        ++this.myNonCancelableCount;
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @NotNull
    public ModalityState getModalityState() {
        return this.myModalityState;
    }

    public void setModalityProgress(ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        ModalityState currentModality = ApplicationManager.getApplication().getCurrentModalityState();
        ModalityState modalityState = this.myModalityState = this.myModalityProgress != null ? ((ModalityStateEx)currentModality).appendProgress(this.myModalityProgress) : currentModality;
        if (modalityProgress != null) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(this.myModalityState);
        }
    }

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    public boolean isPopupWasShown() {
        return true;
    }

    public boolean isShowing() {
        return this.isModal();
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        this.myRunning = indicator.isRunning();
        this.myCanceled = indicator.isCanceled();
        this.myFraction = indicator.getFraction();
        this.myIndeterminate = indicator.isIndeterminate();
        this.myText = indicator.getText();
        this.myText2 = indicator.getText2();
        this.myFraction = indicator.getFraction();
        if (indicator instanceof ProgressIndicatorStacked) {
            ProgressIndicatorStacked stacked = (ProgressIndicatorStacked)indicator;
            this.myNonCancelableCount = stacked.getNonCancelableCount();
            this.myTextStack = new Stack(stacked.getTextStack());
            this.myText2Stack = new Stack(stacked.getText2Stack());
            this.myFractionStack = new DoubleArrayList(stacked.getFractionStack());
        }
        this.myShouldStartActivity = false;
    }

    @Override
    @NotNull
    public synchronized Stack<String> getTextStack() {
        if (this.myTextStack == null) {
            this.myTextStack = new Stack(2);
        }
        return this.myTextStack;
    }

    @Override
    @NotNull
    public synchronized DoubleArrayList getFractionStack() {
        if (this.myFractionStack == null) {
            this.myFractionStack = new DoubleArrayList(2);
        }
        return this.myFractionStack;
    }

    @Override
    @NotNull
    public synchronized Stack<String> getText2Stack() {
        if (this.myText2Stack == null) {
            this.myText2Stack = new Stack(2);
        }
        return this.myText2Stack;
    }

    @Override
    public int getNonCancelableCount() {
        return this.myNonCancelableCount;
    }
}

