/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private final boolean myReusable;
    private volatile boolean myModalityEntered;
    private volatile List<ProgressIndicatorEx> myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            super.start();
            this.delegateRunningChange(ProgressIndicator::start);
        }
        this.myWasStarted = true;
        this.enterModality();
    }

    protected final void enterModality() {
        if (this.myModalityProgress == this) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            if (!(this.myModalityEntered || ApplicationManager.getApplication().isDispatchThread() || ((TransactionGuardImpl)TransactionGuard.getInstance()).isWriteSafeModality(modalityState))) {
                LOG.error("Non-modal progress should be started in a write-safe context: an action or modality-aware invokeLater. See also TransactionGuard documentation.");
            }
            GuiUtils.invokeLaterIfNeeded(this::doEnterModality, (ModalityState)modalityState);
        }
    }

    private void doEnterModality() {
        if (!this.myModalityEntered) {
            LaterInvocator.enterModal(this);
            this.myModalityEntered = true;
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(ProgressIndicator::stop);
        this.exitModality();
    }

    protected final void exitModality() {
        if (this.myModalityProgress == this) {
            GuiUtils.invokeLaterIfNeeded(this::doExitModality, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private void doExitModality() {
        if (this.myModalityEntered) {
            this.myModalityEntered = false;
            LaterInvocator.leaveModal(this);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task) {
        WeakList finished2 = this.myFinished;
        if (finished2 == null) {
            AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
            synchronized (abstractProgressIndicatorExBase) {
                finished2 = this.myFinished;
                if (finished2 == null) {
                    this.myFinished = finished2 = new WeakList();
                }
            }
        }
        if (!finished2.addIfAbsent((Object)task)) {
            return;
        }
        this.delegateRunningChange(each -> each.finish(task));
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task) {
        WeakList<TaskInfo> list = this.myFinished;
        return list != null && list.contains(task);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.delegateProgressChange(each -> each.setText(text));
    }

    @Override
    public void setText2(String text) {
        super.setText2(text);
        this.delegateProgressChange(each -> each.setText2(text));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    @Override
    public synchronized void pushState() {
        super.pushState();
        this.delegateProgressChange(ProgressIndicator::pushState);
    }

    @Override
    public synchronized void popState() {
        super.popState();
        this.delegateProgressChange(ProgressIndicator::popState);
    }

    @Override
    public void startNonCancelableSection() {
        super.startNonCancelableSection();
        this.delegateProgressChange(ProgressIndicator::startNonCancelableSection);
    }

    @Override
    public void finishNonCancelableSection() {
        super.finishNonCancelableSection();
        this.delegateProgressChange(ProgressIndicator::finishNonCancelableSection);
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        delegate.initStateFrom(this);
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            List stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = stateDelegates = ContainerUtil.createLockFreeCopyOnWriteList();
            } else {
                LOG.assertTrue(!stateDelegates.contains(delegate), (Object)("Already registered: " + delegate));
            }
            stateDelegates.add(delegate);
        }
    }

    protected void delegateProgressChange(@NotNull IndicatorAction action) {
        this.delegate(action);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action) {
        List<ProgressIndicatorEx> list = this.myStateDelegates;
        if (list != null && !list.isEmpty()) {
            for (ProgressIndicatorEx each : list) {
                action.execute(each);
            }
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean isModalityEntered() {
        return this.myModalityEntered;
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        super.initStateFrom(indicator);
        if (indicator instanceof ProgressIndicatorEx) {
            this.myModalityEntered = ((ProgressIndicatorEx)indicator).isModalityEntered();
        }
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

