/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis) {
        return BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, false);
    }

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean forceEDT) {
        ModalityState modality = ModalityState.current();
        if (forceEDT) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback2 = (Runnable)backgroundTask.fun((Object)indicator2);
                BackgroundTaskUtil.finish(callback2, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback2) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            return indicator2;
        }
        Pair<Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback, indicator), modality), modality, waitMillis);
        Runnable callback3 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback3 != null) {
            BackgroundTaskUtil.finish(callback3, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        return indicator3;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (!indicator.isCanceled()) {
            result2.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<ProgressIndicator, T> backgroundTask, long waitMillis) {
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result2, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result3 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result3;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<T> computable, @NotNull Consumer<T> asyncCallback, long waitMillis) {
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> computable.compute(), (result2, indicator) -> asyncCallback.consume(result2), ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    public static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<ProgressIndicator, T> task, @NotNull PairConsumer<T, ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        Helper helper = new Helper();
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$6(task, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result2 = null;
        if (helper.await(waitMillis)) {
            result2 = helper.getResult();
        }
        return Pair.create(result2, (Object)indicator);
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Runnable runnable2, @NotNull Disposable parent) {
        return BackgroundTaskUtil.executeOnPooledThread((Consumer<ProgressIndicator>)((Consumer)indicator -> runnable2.run()), parent);
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return BackgroundTaskUtil.executeOnPooledThread(task, parent, modalityState);
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent, @NotNull ModalityState modalityState) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modalityState);
        Disposable disposable = new Disposable((ProgressIndicator)indicator){
            final /* synthetic */ ProgressIndicator val$indicator;
            {
                this.val$indicator = progressIndicator;
            }

            public void dispose() {
                if (this.val$indicator.isRunning()) {
                    this.val$indicator.cancel();
                }
            }
        };
        Disposer.register((Disposable)parent, (Disposable)disposable);
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$9(task, (ProgressIndicator)indicator, disposable));
        return indicator;
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$9(@NotNull Consumer task, ProgressIndicator indicator, Disposable disposable) {
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                task.consume((Object)indicator);
            }
            finally {
                indicator.stop();
                Disposer.dispose((Disposable)disposable);
            }
        }, indicator);
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$6(@NotNull Function task, ProgressIndicator indicator, Helper helper, @NotNull PairConsumer asyncCallback) {
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                Object result2 = task.fun((Object)indicator);
                if (!helper.setResult(result2)) {
                    asyncCallback.consume(result2, (Object)indicator);
                }
            }
            finally {
                indicator.stop();
            }
        }, indicator);
    }

    private static class Helper<T> {
        private static final Object INITIAL_STATE = new Object();
        private static final Object SLOW_OPERATION_STATE = new Object();
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result2) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result2);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result2 = this.myResultRef.get();
            assert (result2 != INITIAL_STATE && result2 != SLOW_OPERATION_STATE);
            return (T)result2;
        }
    }
}

