/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.SunToolkit;

public class PotemkinProgress
extends ProgressWindow {
    private long myLastUiUpdate = System.currentTimeMillis();
    private final LinkedBlockingQueue<InputEvent> myEventQueue = new LinkedBlockingQueue();
    private long myLastShouldDispatchCheck = 0L;

    public PotemkinProgress(@NotNull String title, @Nullable Project project2, @Nullable JComponent parentComponent, @Nullable String cancelText) {
        super(cancelText != null, false, project2, parentComponent, cancelText);
        this.setTitle(title);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.startStealingInputEvents();
    }

    private void startStealingInputEvents() {
        IdeEventQueue.getInstance().addPostEventListener(event -> {
            if (event instanceof InputEvent) {
                this.myEventQueue.offer((InputEvent)event);
                return true;
            }
            return false;
        }, this);
    }

    @Override
    @NotNull
    protected ProgressDialog getDialog() {
        return Objects.requireNonNull(super.getDialog());
    }

    public void interact() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            long now = System.currentTimeMillis();
            if (this.shouldDispatchAwtEvents(now)) {
                this.dispatchAwtEventsWithoutModelAccess(0);
            }
            this.updateUI(now);
        }
    }

    private void dispatchAwtEventsWithoutModelAccess(int timeoutMs) {
        SunToolkit.flushPendingEvents();
        try {
            while (true) {
                InputEvent event;
                if ((event = this.myEventQueue.poll(timeoutMs, TimeUnit.MILLISECONDS)) == null) {
                    return;
                }
                this.dispatchInputEvent(event);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldDispatchAwtEvents(long now) {
        if (now == this.myLastShouldDispatchCheck) {
            return false;
        }
        this.myLastShouldDispatchCheck = now;
        return this.getDialog().getPanel().isShowing();
    }

    private void dispatchInputEvent(InputEvent e) {
        if (this.isCancellationEvent(e)) {
            this.cancel();
            return;
        }
        Object source = e.getSource();
        if (source instanceof Component && this.isInDialogWindow((Component)source)) {
            ((Component)source).dispatchEvent(e);
        }
    }

    private boolean isInDialogWindow(Component source) {
        Window dialogWindow = SwingUtilities.windowForComponent(this.getDialog().getPanel());
        return dialogWindow instanceof JDialog && SwingUtilities.isDescendingFrom(source, dialogWindow);
    }

    private void updateUI(long now) {
        JRootPane rootPane = this.getDialog().getPanel().getRootPane();
        if (rootPane == null) {
            rootPane = this.considerShowingDialog(now);
        }
        if (rootPane != null && this.timeToPaint(now)) {
            this.paintProgress();
        }
    }

    @Nullable
    private JRootPane considerShowingDialog(long now) {
        if (now - this.myLastUiUpdate > 300L) {
            this.getDialog().myRepaintRunnable.run();
            this.showDialog();
            return this.getDialog().getPanel().getRootPane();
        }
        return null;
    }

    private boolean timeToPaint(long now) {
        if (now - this.myLastUiUpdate <= 50L) {
            return false;
        }
        this.myLastUiUpdate = now;
        return true;
    }

    private void progressFinished() {
        this.getDialog().hideImmediately();
    }

    private void paintProgress() {
        this.getDialog().myRepaintRunnable.run();
        JPanel dialogPanel = this.getDialog().getPanel();
        dialogPanel.validate();
        dialogPanel.paintImmediately(dialogPanel.getBounds());
    }

    public void runInSwingThread(@NotNull Runnable action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            ProgressManager.getInstance().runProcess(action, (ProgressIndicator)this);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.progressFinished();
        }
    }

    public void runInBackground(@NotNull Runnable action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.enterModality();
        try {
            this.ensureBackgroundThreadStarted(action);
            while (this.isRunning()) {
                this.dispatchAwtEventsWithoutModelAccess(10);
                this.updateUI(System.currentTimeMillis());
            }
        }
        finally {
            this.exitModality();
            this.progressFinished();
        }
    }

    private void ensureBackgroundThreadStarted(@NotNull Runnable action) {
        Semaphore started = new Semaphore();
        started.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            started.up();
            action.run();
        }, (ProgressIndicator)this));
        started.waitFor();
    }
}

