/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable parentDisposable) {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, parentDisposable);
        return progress;
    }

    @NotNull
    public static CompletableFuture<?> submitWithWriteActionPriority(@NotNull ReadTask task) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        ProgressIndicatorUtils.submitWithWriteActionPriority(task);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull Executor executor, @NotNull ReadTask task) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), executor, task);
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), progressIndicator == null ? new ProgressIndicatorBase() : progressIndicator);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithWriteActionPriority(@NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        if (application.isWriteActionPending()) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        ApplicationAdapter listener2 = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (!progressIndicator.isCanceled()) {
                    progressIndicator.cancel();
                }
            }
        };
        boolean succeededWithAddingListener = application.tryRunReadAction(() -> application.addApplicationListener((ApplicationListener)listener2));
        if (!succeededWithAddingListener) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        Ref wasCancelled = new Ref();
        try {
            ProgressManager.getInstance().runProcess(() -> {
                try {
                    action.run();
                }
                catch (ProcessCanceledException ignore) {
                    wasCancelled.set((Object)Boolean.TRUE);
                }
            }, progressIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener2);
        }
        return wasCancelled.get() != Boolean.TRUE;
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        final CompletableFuture future2 = new CompletableFuture();
        EdtInvocationManager.getInstance().invokeLater(() -> {
            final Application application = ApplicationManager.getApplication();
            if (application.isDisposed() || progressIndicator.isCanceled()) {
                future2.complete(null);
                return;
            }
            final ApplicationAdapter listener2 = new ApplicationAdapter(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (!progressIndicator.isCanceled()) {
                        progressIndicator.cancel();
                        readTask.onCanceled(progressIndicator);
                    }
                }
            };
            application.addApplicationListener((ApplicationListener)listener2);
            future2.whenComplete((o, throwable) -> application.removeApplicationListener((ApplicationListener)listener2));
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    application.removeApplicationListener((ApplicationListener)listener2);
                                    try {
                                        if (!progressIndicator.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                });
            }
            catch (Error | RuntimeException e) {
                future2.completeExceptionally(e);
                throw e;
            }
        });
        return future2;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask task) {
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task.runBackgroundProcess(progressIndicator);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator);
    }

    public static void yieldToPendingWriteActions() {
        ApplicationManager.getApplication().invokeAndWait(EmptyRunnable.INSTANCE, ModalityState.any());
    }
}

