/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.FileContentQueue");
    private static final long MAX_SIZE_OF_BYTES_IN_QUEUE = 0x100000L;
    private static final long PROCESSED_FILE_BYTES_THRESHOLD = 0x300000L;
    private static final long LARGE_SIZE_REQUEST_THRESHOLD = 2838528L;
    private static final int ourTasksNumber = SystemProperties.getBooleanProperty((String)"idea.allow.parallel.file.reading", (boolean)true) ? CacheUpdateRunner.indexingThreadCount() : 1;
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileContentQueue pool", (int)ourTasksNumber);
    private final LinkedBlockingDeque<FileContent> myLoadedContents = new LinkedBlockingDeque();
    private final AtomicInteger myContentsToLoad = new AtomicInteger();
    private final AtomicLong myLoadedBytesInQueue = new AtomicLong();
    private final Object myProceedWithLoadingLock = new Object();
    private volatile long myBytesBeingProcessed;
    private volatile boolean myLargeSizeRequested;
    private final Object myProceedWithProcessingLock = new Object();
    private final BlockingQueue<VirtualFile> myFilesQueue;
    private final ProgressIndicator myProgressIndicator;
    private static final Deque<FileContentQueue> ourContentLoadingQueues = new LinkedBlockingDeque<FileContentQueue>();

    public FileContentQueue(@NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        int numberOfFiles = files.size();
        this.myContentsToLoad.set(numberOfFiles);
        this.myFilesQueue = numberOfFiles > 0 ? new ArrayBlockingQueue<VirtualFile>(numberOfFiles, false, files) : null;
        this.myProgressIndicator = indicator;
    }

    public void startLoading() {
        if (this.myContentsToLoad.get() == 0) {
            return;
        }
        for (int i2 = 0; i2 < ourTasksNumber; ++i2) {
            ourContentLoadingQueues.addLast(this);
            Runnable task = () -> {
                FileContentQueue contentQueue = ourContentLoadingQueues.pollFirst();
                while (contentQueue != null) {
                    if (contentQueue.loadNextContent()) {
                        ourContentLoadingQueues.addLast(contentQueue);
                    }
                    contentQueue = ourContentLoadingQueues.pollFirst();
                }
            };
            ourExecutor.submit(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextContent() {
        VirtualFile file2 = (VirtualFile)this.myFilesQueue.poll();
        if (file2 == null || this.myProgressIndicator.isCanceled()) {
            return false;
        }
        try {
            this.myProgressIndicator.checkCanceled();
            this.myLoadedContents.offer(this.loadContent(file2, this.myProgressIndicator));
        }
        catch (ProcessCanceledException e) {
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myContentsToLoad.addAndGet(-1);
        }
        return true;
    }

    private FileContent loadContent(@NotNull VirtualFile file2, @NotNull ProgressIndicator indicator) throws InterruptedException {
        FileContent content = new FileContent(file2);
        if (!FileContentQueue.isValidFile(file2) || !this.doLoadContent(content, indicator)) {
            content.setEmptyContent();
        }
        return content;
    }

    private static boolean isValidFile(@NotNull VirtualFile file2) {
        return file2.isValid() && !file2.isDirectory() && !file2.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink((VirtualFile)file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadContent(@NotNull FileContent content, @NotNull ProgressIndicator indicator) throws InterruptedException {
        long contentLength = content.getLength();
        boolean counterUpdated = false;
        try {
            while (this.myLoadedBytesInQueue.get() > 0x100000L) {
                indicator.checkCanceled();
                Object object = this.myProceedWithLoadingLock;
                synchronized (object) {
                    this.myProceedWithLoadingLock.wait(300L);
                }
            }
            this.myLoadedBytesInQueue.addAndGet(contentLength);
            counterUpdated = true;
            content.getBytes();
            return true;
        }
        catch (Throwable e) {
            if (counterUpdated) {
                this.myLoadedBytesInQueue.addAndGet(-contentLength);
            }
            if (e instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof IOException || e instanceof InvalidVirtualFileAccessException) {
                if (e instanceof FileNotFoundException) {
                    LOG.debug(e);
                } else {
                    LOG.info(e);
                }
            } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                e.printStackTrace();
            } else {
                LOG.error(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileContent take(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        FileContent content = this.doTake(indicator);
        if (content == null) {
            return null;
        }
        long length = content.getLength();
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                this.pushBack(content);
                throw e;
            }
            Object object = this.myProceedWithProcessingLock;
            synchronized (object) {
                boolean requestingLargeSize;
                boolean bl = requestingLargeSize = length > 2838528L;
                if (requestingLargeSize) {
                    this.myLargeSizeRequested = true;
                }
                try {
                    if ((!this.myLargeSizeRequested || requestingLargeSize) && this.myBytesBeingProcessed + length <= Math.max(0x300000L, length)) {
                        this.myBytesBeingProcessed += length;
                        if (requestingLargeSize) {
                            this.myLargeSizeRequested = false;
                        }
                        return content;
                    }
                    this.myProceedWithProcessingLock.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileContent doTake(ProgressIndicator indicator) {
        FileContent result2 = null;
        while (result2 == null) {
            try {
                int remainingContentsToLoad = this.myContentsToLoad.get();
                result2 = this.myLoadedContents.poll(50L, TimeUnit.MILLISECONDS);
                if (result2 != null) continue;
                if (remainingContentsToLoad == 0) {
                    return null;
                }
                indicator.checkCanceled();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        long loadedBytesInQueueNow = this.myLoadedBytesInQueue.addAndGet(-result2.getLength());
        if (loadedBytesInQueueNow < 0x100000L) {
            Object object = this.myProceedWithLoadingLock;
            synchronized (object) {
                this.myProceedWithLoadingLock.notifyAll();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull FileContent content) {
        Object object = this.myProceedWithProcessingLock;
        synchronized (object) {
            this.myBytesBeingProcessed -= content.getLength();
            this.myProceedWithProcessingLock.notifyAll();
        }
    }

    public void pushBack(@NotNull FileContent content) {
        this.myLoadedBytesInQueue.addAndGet(content.getLength());
        this.myLoadedContents.addFirst(content);
    }
}

