/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectImpl myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Map<String, Project> myOpenProjectByHash = ContainerUtil.newConcurrentMap();
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS;
    private static final int MAX_LEAKY_PROJECTS = 5;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project2) {
        List array = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            return Collections.emptyList();
        }
        return array;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        final ProjectManagerListener busPublisher = (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                busPublisher.projectOpened(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectOpened(project2);
                }
            }

            public void projectClosed(Project project2) {
                busPublisher.projectClosed(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosed(project2);
                }
                ZipHandler.clearFileAccessorCache();
                LaterInvocator.purgeExpiredItems();
            }

            public boolean canCloseProject(Project project2) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    if (listener2.canCloseProject(project2)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project2) {
                busPublisher.projectClosing(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosing(project2);
                }
            }
        });
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        File projectFile;
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            this.checkProjectLeaksInTests();
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files = new File(projectFile, ".idea").listFiles();
            if (files != null) {
                for (File file2 : files) {
                    FileUtil.delete((File)file2);
                }
            }
        }
        ProjectImpl project2 = this.createProject(projectName, filePath, false);
        try {
            this.initProject(project2, useDefaultProjectSettings ? this.getDefaultProject() : null);
            if (LOG_PROJECT_LEAKAGE_IN_TESTS) {
                this.myProjects.put(project2, null);
            }
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        String message2 = e.getMessage();
        if (message2 != null) {
            return message2;
        }
        message2 = e.getLocalizedMessage();
        if (message2 != null) {
            return message2;
        }
        message2 = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            return message2 + " (cause: " + causeMessage + ")";
        }
        return message2;
    }

    private void checkProjectLeaksInTests() {
        if (!LOG_PROJECT_LEAKAGE_IN_TESTS || this.getLeakedProjects().count() < 5L) {
            return;
        }
        if (Math.random() >= 0.05) {
            return;
        }
        for (int i = 0; i < 3 && this.getLeakedProjects().count() >= 5L; ++i) {
            GCUtil.tryGcSoftlyReachableObjects();
        }
        System.gc();
        if (this.getLeakedProjects().count() >= 5L) {
            List copy = (List)this.getLeakedProjects().collect(Collectors.toCollection(UnsafeWeakList::new));
            this.myProjects.clear();
            throw new TooManyProjectLeakedException(copy);
        }
    }

    private Stream<Project> getLeakedProjects() {
        return this.myProjects.keySet().stream().filter(project2 -> project2.isDisposed() && !((ProjectImpl)project2).isTemporarilyDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project2, @Nullable Project template) {
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project2.isDefault()) {
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project2.getName()}));
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project2);
        boolean succeed = false;
        try {
            if (template != null) {
                project2.getStateStore().loadProjectFromTemplate(template);
            }
            project2.init();
            succeed = true;
        }
        finally {
            if (!succeed && !project2.isDefault()) {
                TransactionGuard.submitTransaction((Disposable)project2, () -> WriteAction.run(() -> Disposer.dispose((Disposable)project2)));
            }
        }
    }

    private ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault) {
        if (isDefault) {
            return new DefaultProject(this, "");
        }
        return new ProjectImpl(this, FileUtilRt.toSystemIndependentName((String)filePath), projectName);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        return this.loadProject(filePath, null);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath, @Nullable String projectName) throws IOException {
        try {
            ProjectImpl project2 = this.createProject(projectName, new File(filePath).getAbsolutePath(), false);
            this.initProject(project2, null);
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        try {
            return FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            return filePath;
        }
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    this.myDefaultProject = this.createProject(null, "", true);
                    this.initProject(this.myDefaultProject, null);
                }
                catch (Throwable t) {
                    PluginManager.processException(t);
                }
            });
        }
        return this.myDefaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOpenProjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project2) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project2, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project2) {
        if (ProjectManagerImpl.isLight(project2)) {
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project2).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project2);
                return true;
            }
        }
        for (Project p : this.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(project2.getProjectFilePath(), p)) continue;
            GuiUtils.invokeLaterIfNeeded(() -> ProjectUtil.focusProjectWindow(p, false), (ModalityState)ModalityState.NON_MODAL);
            return false;
        }
        if (!this.addToOpened(project2)) {
            return false;
        }
        Runnable process2 = () -> {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.fireProjectOpened(project2));
            StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project2);
            startupManager.runStartupActivities();
            TransactionGuard.getInstance().submitTransactionAndWait(startupManager::startCacheUpdate);
            startupManager.runPostStartupActivitiesFromExtensions();
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!project2.isDisposed()) {
                    startupManager.runPostStartupActivities();
                    Application application = ApplicationManager.getApplication();
                    if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
                        StorageUtilKt.checkUnknownMacros(project2, true);
                    }
                }
            }, (ModalityState)ModalityState.NON_MODAL);
        };
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null) {
            indicator.setText("Preparing workspace...");
            process2.run();
            return true;
        }
        boolean ok = this.myProgressManager.runProcessWithProgressSynchronously(process2, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project2);
        if (!ok) {
            this.closeProject(project2, false, false, true);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project2) {
        assert (!project2.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project2)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project2);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project2 : null;
            this.myOpenProjectByHash.put(project2.getLocationHash(), project2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOpened(@NotNull Project project2) {
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project2);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
            this.myOpenProjectByHash.values().remove(project2);
        }
    }

    @Nullable
    public Project findOpenProjectByHash(@Nullable String locationHash) {
        return this.myOpenProjectByHash.get(locationHash);
    }

    private static boolean canCancelProjectLoading() {
        return !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public Project loadAndOpenProject(@NotNull String originalFilePath) throws IOException {
        ProjectImpl project2;
        String filePath = ProjectManagerImpl.toCanonicalName(originalFilePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(filePath);
        if (conversionResult.openingIsCanceled()) {
            project2 = null;
        } else {
            project2 = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false);
            this.myProgressManager.run((Task.WithResult)new Task.WithResult<Project, IOException>((Project)project2, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true){

                protected Project compute(@NotNull ProgressIndicator indicator) throws IOException {
                    if (!ProjectManagerImpl.this.loadProjectWithProgress(project2)) {
                        return null;
                    }
                    if (!conversionResult.conversionNotNeeded()) {
                        StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project2));
                    }
                    ProjectManagerImpl.this.openProject(project2);
                    return project2;
                }
            });
        }
        if (project2 == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!project2.isOpen()) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (!project2.isDisposed()) {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        return project2;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        String fp = ProjectManagerImpl.toCanonicalName(filePath);
        ConversionResult conversionResult = ConversionService.getInstance().convert(fp);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        ProjectImpl project2 = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false);
        if (!this.loadProjectWithProgress(project2)) {
            return null;
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project2));
        }
        return project2;
    }

    private boolean loadProjectWithProgress(ProjectImpl project2) throws IOException {
        try {
            if (this.myProgressManager.getProgressIndicator() != null) {
                this.initProject(project2, null);
                return true;
            }
            this.myProgressManager.runProcessWithProgressSynchronously(() -> {
                this.initProject(project2, null);
                return project2;
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project2);
            return true;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    private static void notifyProjectOpenFailed() {
        Application application = ApplicationManager.getApplication();
        ((AppLifecycleListener)application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        if (application.isUnitTestMode()) {
            return;
        }
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project2);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.closeProject(project2, false, false, false);
        Project[] projects = this.getOpenProjects();
        return projects.length == 0 ? Collections.emptyList() : Arrays.asList(projects);
    }

    public void reloadProject(@NotNull Project project2) {
        ProjectManagerImpl.doReloadProject(project2);
    }

    public static void doReloadProject(@NotNull Project project2) {
        Ref projectRef = Ref.create((Object)project2);
        ProjectReloadState.getInstance((Project)project2).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Reloading project.");
            Project project1 = (Project)projectRef.get();
            projectRef.set(null);
            if (project1.isDisposed()) {
                return;
            }
            String presentableUrl = project1.getPresentableUrl();
            if (!ProjectUtil.closeAndDispose(project1)) {
                return;
            }
            ProjectUtil.openProject(presentableUrl, null, true);
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project2) {
        return this.closeProject(project2, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeProject(@NotNull Project project2, boolean save2, boolean dispose, boolean checkCanClose) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ProjectManagerImpl.isLight(project2)) {
            if (!((ProjectImpl)project2).isTemporarilyDisposed()) {
                ((ProjectImpl)project2).setTemporarilyDisposed(true);
                this.removeFromOpened(project2);
                return true;
            }
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project2)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project2)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save2) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project2.save();
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project2)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project2);
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.removeFromOpened(project2);
                this.fireProjectClosed(project2);
                if (dispose) {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project2) {
        return project2 instanceof ProjectImpl && ((ProjectImpl)project2).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project2) {
        return this.closeProject(project2, true, true, true);
    }

    private void fireProjectClosing(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosing(project2);
            }
            catch (Exception e) {
                LOG.error("From listener " + listener2 + " (" + listener2.getClass() + ")", (Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeProjectManagerListener(listener2));
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project2).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectOpened(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosed(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                if (listener2.canCloseProject(project2)) continue;
                LOG.debug("close canceled by " + listener2);
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project2) {
        VirtualFile[] files;
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project2);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message2 = new StringBuilder();
        message2.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message2.append("\n\nRead-only files:\n");
        int count = 0;
        for (VirtualFile file2 : files = notifications[0].myFiles) {
            if (count == 10) {
                message2.append('\n').append("and ").append(files.length - count).append(" more").append('\n');
                continue;
            }
            message2.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project2, (String)message2.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    static {
        LOG_PROJECT_LEAKAGE_IN_TESTS = Boolean.parseBoolean(System.getProperty("idea.log.leaked.projects.in.tests", "false"));
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        public VirtualFile[] myFiles;

        public UnableToSaveProjectNotification(@NotNull Project project2, @NotNull VirtualFile[] readOnlyFiles) {
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, (notification, event) -> {
                UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                Project _project = unableToSaveProjectNotification.myProject;
                notification.expire();
                if (_project != null && !_project.isDisposed()) {
                    _project.save();
                }
            });
            this.myProject = project2;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

