/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class CompositeProjectRoot
implements ProjectRoot {
    private final List<ProjectRoot> myRoots = new ArrayList<ProjectRoot>();

    CompositeProjectRoot() {
    }

    @NotNull
    ProjectRoot[] getProjectRoots() {
        return this.myRoots.toArray(new ProjectRoot[this.myRoots.size()]);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        ArrayList result2 = new ArrayList();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result2, (Object[])root.getVirtualFiles());
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @Override
    @NotNull
    public String[] getUrls() {
        ArrayList result2 = new ArrayList();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result2, (Object[])root.getUrls());
        }
        return ArrayUtil.toStringArray(result2);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    void remove(@NotNull ProjectRoot root) {
        this.myRoots.remove(root);
    }

    @NotNull
    ProjectRoot add(@NotNull VirtualFile virtualFile) {
        SimpleProjectRoot root = new SimpleProjectRoot(virtualFile);
        this.myRoots.add(root);
        return root;
    }

    void add(@NotNull ProjectRoot root) {
        this.myRoots.add(root);
    }

    void remove(@NotNull VirtualFile root) {
        Iterator<ProjectRoot> iterator = this.myRoots.iterator();
        while (iterator.hasNext()) {
            SimpleProjectRoot r;
            ProjectRoot projectRoot = iterator.next();
            if (!(projectRoot instanceof SimpleProjectRoot) || !root.equals((r = (SimpleProjectRoot)projectRoot).getFile())) continue;
            iterator.remove();
        }
    }

    void clear() {
        this.myRoots.clear();
    }

    public void readExternal(Element element) {
        for (Element child : element.getChildren()) {
            this.myRoots.add(ProjectRootUtil.read(child));
        }
    }

    public void writeExternal(Element element) {
        for (ProjectRoot root : this.myRoots) {
            Element e = ProjectRootUtil.write(root);
            if (e == null) continue;
            element.addContent(e);
        }
    }

    @Override
    public void update() {
        for (ProjectRoot root : this.myRoots) {
            root.update();
        }
    }
}

