/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.impl.WindowsJavaFinder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaHomeFinder {
    @NotNull
    public static List<String> suggestHomePaths() {
        ArrayList<String> paths = new ArrayList<String>(new HashSet<String>(JavaHomeFinder.getFinder().findExistingJdks()));
        paths.sort((o1, o2) -> Comparing.compare((Comparable)JdkVersionUtil.getVersion((String)o2), (Comparable)JdkVersionUtil.getVersion((String)o1)));
        return paths;
    }

    @NotNull
    protected abstract List<String> findExistingJdks();

    private static JavaHomeFinder getFinder() {
        if (SystemInfo.isWindows) {
            return new WindowsJavaFinder();
        }
        if (SystemInfo.isMac) {
            return new MacFinder();
        }
        if (SystemInfo.isLinux) {
            return new DefaultFinder("/usr/java", "/opt/java", "/usr/lib/jvm");
        }
        if (SystemInfo.isSolaris) {
            return new DefaultFinder("/usr/jdk");
        }
        return new DefaultFinder(new String[0]);
    }

    protected static void scanFolder(File javasFolder, List<String> result2) {
        File[] candidates = javasFolder.listFiles(JdkUtil::checkForJdk);
        if (candidates != null) {
            for (File file2 : candidates) {
                result2.add(file2.getAbsolutePath());
            }
        }
    }

    private static class MacFinder
    extends DefaultFinder {
        public MacFinder() {
            super("/Library/Java/JavaVirtualMachines", "/System/Library/Java/JavaVirtualMachines");
        }

        @Override
        @NotNull
        public List<String> findExistingJdks() {
            String path;
            List<String> list = super.findExistingJdks();
            if (new File("/usr/libexec/java_home").canExecute() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"/usr/libexec/java_home"}))) != null && new File(path).isDirectory()) {
                list.add(path);
            }
            return list;
        }
    }

    protected static class DefaultFinder
    extends JavaHomeFinder {
        private final String[] myPaths;

        protected DefaultFinder(String ... paths) {
            this.myPaths = paths;
        }

        @Override
        @NotNull
        public List<String> findExistingJdks() {
            ArrayList<String> result2 = new ArrayList<String>();
            for (String path : this.myPaths) {
                JavaHomeFinder.scanFolder(new File(path), result2);
            }
            return result2;
        }
    }
}

