/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectRootContainerImpl
implements JDOMExternalizable,
ProjectRootContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, CompositeProjectRoot> myRoots = new HashMap();
    private Map<OrderRootType, VirtualFile[]> myFiles = new HashMap();
    private boolean myInsideChange = false;
    private final List<ProjectRootListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myNoCopyJars = false;

    public ProjectRootContainerImpl(boolean noCopyJars) {
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, new CompositeProjectRoot());
            this.myFiles.put(rootType, VirtualFile.EMPTY_ARRAY);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type2) {
        return (VirtualFile[])ObjectUtils.chooseNotNull((Object)this.myFiles.get(type2), (Object)VirtualFile.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public ProjectRoot[] getRoots(@NotNull OrderRootType type2) {
        return this.myRoots.get(type2).getProjectRoots();
    }

    @Override
    public void startChange() {
        LOG.assertTrue(!this.myInsideChange);
        this.myInsideChange = true;
    }

    @Override
    public void finishChange() {
        LOG.assertTrue(this.myInsideChange);
        HashMap oldRoots = new HashMap(this.myFiles);
        boolean changes = false;
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            Object[] roots = this.myRoots.get(orderRootType).getVirtualFiles();
            changes = changes || !Comparing.equal((Object[])roots, (Object[])((Object[])oldRoots.get((Object)orderRootType)));
            this.myFiles.put(orderRootType, (VirtualFile[])roots);
        }
        if (changes) {
            this.fireRootsChanged();
        }
        this.myInsideChange = false;
    }

    public void addProjectRootContainerListener(ProjectRootListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeProjectRootContainerListener(ProjectRootListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void fireRootsChanged() {
        for (ProjectRootListener listener2 : this.myListeners) {
            listener2.rootsChanged();
        }
    }

    @Override
    public void removeRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type2) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type2).remove(root);
    }

    @Override
    @NotNull
    public ProjectRoot addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type2) {
        LOG.assertTrue(this.myInsideChange);
        return this.myRoots.get(type2).add(virtualFile);
    }

    @Override
    public void addRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type2) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type2).add(root);
    }

    @Override
    public void removeAllRoots(@NotNull OrderRootType type2) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type2).clear();
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type2) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type2).remove(root);
    }

    @Override
    public void removeAllRoots() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    @Override
    public void update() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.update();
        }
    }

    public void readExternal(Element element) {
        for (PersistentOrderRootType type2 : OrderRootType.getAllPersistentTypes()) {
            this.read(element, type2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myFiles = new HashMap();
            for (OrderRootType rootType : this.myRoots.keySet()) {
                CompositeProjectRoot root = this.myRoots.get(rootType);
                if (this.myNoCopyJars) {
                    ProjectRootContainerImpl.setNoCopyJars(root);
                }
                this.myFiles.put(rootType, root.getVirtualFiles());
            }
        });
        PersistentOrderRootType[] persistentOrderRootTypeArray = OrderRootType.getAllTypes();
        int n = persistentOrderRootTypeArray.length;
        for (int i = 0; i < n; ++i) {
            PersistentOrderRootType type2;
            Object[] oldRoots = VirtualFile.EMPTY_ARRAY;
            type2 = persistentOrderRootTypeArray[i];
            Object[] newRoots = this.getRootFiles((OrderRootType)type2);
            if (Comparing.equal((Object[])oldRoots, (Object[])newRoots)) continue;
            this.fireRootsChanged();
            break;
        }
    }

    public void writeExternal(Element element) {
        List allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type2 : allTypes) {
            this.write(element, type2);
        }
    }

    private static void setNoCopyJars(ProjectRoot root) {
        block3: {
            block2: {
                if (!(root instanceof SimpleProjectRoot)) break block2;
                String url = ((SimpleProjectRoot)root).getUrl();
                if (!"jar".equals(VirtualFileManager.extractProtocol((String)url))) break block3;
                String path = VirtualFileManager.extractPath((String)url);
                VirtualFileSystem fileSystem = StandardFileSystems.jar();
                if (!(fileSystem instanceof JarCopyingFileSystem)) break block3;
                ((JarCopyingFileSystem)fileSystem).setNoCopyJarForPath(path);
                break block3;
            }
            if (root instanceof CompositeProjectRoot) {
                ProjectRoot[] roots;
                for (ProjectRoot root1 : roots = ((CompositeProjectRoot)root).getProjectRoots()) {
                    ProjectRootContainerImpl.setNoCopyJars(root1);
                }
            }
        }
    }

    private void read(Element element, PersistentOrderRootType type2) {
        Element child;
        String sdkRootName = type2.getSdkRootName();
        Element element2 = child = sdkRootName != null ? element.getChild(sdkRootName) : null;
        if (child == null) {
            this.myRoots.put((OrderRootType)type2, new CompositeProjectRoot());
            return;
        }
        List children2 = child.getChildren();
        LOG.assertTrue(children2.size() == 1);
        CompositeProjectRoot root = (CompositeProjectRoot)ProjectRootUtil.read((Element)children2.get(0));
        this.myRoots.put((OrderRootType)type2, root);
    }

    private void write(Element roots, PersistentOrderRootType type2) {
        String sdkRootName = type2.getSdkRootName();
        if (sdkRootName != null) {
            Element e = new Element(sdkRootName);
            roots.addContent(e);
            Element root = ProjectRootUtil.write(this.myRoots.get(type2));
            if (root != null) {
                e.addContent(root);
            }
        }
    }

    void readOldVersion(Element child) {
        block0: for (Element root : child.getChildren("root")) {
            String url = root.getAttributeValue("file");
            SimpleProjectRoot projectRoot = new SimpleProjectRoot(url);
            String type2 = root.getChild("property").getAttributeValue("value");
            for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
                if (!type2.equals(rootType.getOldSdkRootName())) continue;
                this.addRoot(projectRoot, (OrderRootType)rootType);
                continue block0;
            }
        }
        this.myFiles = new HashMap();
        for (OrderRootType rootType : this.myRoots.keySet()) {
            this.myFiles.put(rootType, this.myRoots.get(rootType).getVirtualFiles());
        }
        Iterator<Object> iterator = OrderRootType.getAllTypes();
        int n = ((Iterator<Object>)iterator).length;
        for (int i = 0; i < n; ++i) {
            Object[] oldRoots = VirtualFile.EMPTY_ARRAY;
            Iterator<Object> type3 = iterator[i];
            Object[] newRoots = this.getRootFiles((OrderRootType)type3);
            if (Comparing.equal((Object[])oldRoots, (Object[])newRoots)) continue;
            this.fireRootsChanged();
            break;
        }
    }
}

