/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimpleProjectRoot
implements ProjectRoot {
    private String myUrl;
    private VirtualFile myFile;
    private final VirtualFile[] myFileArray = new VirtualFile[1];
    private boolean myInitialized = false;
    @NonNls
    private static final String ATTRIBUTE_URL = "url";

    public SimpleProjectRoot(@NotNull VirtualFile file2) {
        this.myFile = file2;
        this.myUrl = this.myFile.getUrl();
    }

    public SimpleProjectRoot(@NotNull String url) {
        this.myUrl = url;
    }

    SimpleProjectRoot() {
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        String path = VirtualFileManager.extractPath((String)this.myUrl);
        path = StringUtil.trimEnd((String)path, (String)"!/");
        return path.replace('/', File.separatorChar);
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (this.myFile == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        this.myFileArray[0] = this.myFile;
        return this.myFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        return new String[]{this.myUrl};
    }

    @Override
    public boolean isValid() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myFile != null && this.myFile.isValid();
    }

    @Override
    public void update() {
        this.initialize();
    }

    private void initialize() {
        this.myInitialized = true;
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
            if (this.myFile != null && !this.canHaveChildren()) {
                this.myFile = null;
            }
        }
    }

    private boolean canHaveChildren() {
        return this.myFile.getFileSystem().getProtocol().equals("http") || this.myFile.isDirectory();
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void readExternal(Element element) {
        String url = element.getAttributeValue(ATTRIBUTE_URL);
        this.myUrl = SimpleProjectRoot.migrateJdkAnnotationsToCommunityForDevIdea(url);
    }

    private static String migrateJdkAnnotationsToCommunityForDevIdea(String url) {
        boolean isOldJdkAnnotations;
        File root = new File(VfsUtilCore.urlToPath((String)url) + "/..");
        boolean bl = isOldJdkAnnotations = new File(root, "community/java/jdkAnnotations").exists() && new File(root, "idea.iml").exists() && new File(root, "testData").exists();
        if (isOldJdkAnnotations) {
            return VfsUtilCore.pathToUrl((String)PathUtil.getCanonicalPath((String)VfsUtilCore.urlToPath((String)(url + "/../community/java/jdkAnnotations"))));
        }
        return url;
    }

    public void writeExternal(Element element) {
        if (!this.myInitialized) {
            this.initialize();
        }
        element.setAttribute(ATTRIBUTE_URL, this.myUrl);
    }
}

