/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.ExcludeFolderImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SourceFolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

public class ContentEntryImpl
extends RootModelComponentBase
implements ContentEntry,
ClonableContentEntry,
Comparable<ContentEntryImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.SimpleContentEntryImpl");
    @NotNull
    private final VirtualFilePointer myRoot;
    @NonNls
    public static final String ELEMENT_NAME = "content";
    private final Set<SourceFolder> mySourceFolders = new LinkedHashSet<SourceFolder>();
    private final Set<ExcludeFolder> myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
    @NonNls
    public static final String URL_ATTRIBUTE = "url";

    ContentEntryImpl(@NotNull VirtualFile file2, @NotNull RootModelImpl m) {
        this(file2.getUrl(), m);
    }

    ContentEntryImpl(@NotNull String url, @NotNull RootModelImpl m) {
        super(m);
        this.myRoot = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    ContentEntryImpl(@NotNull Element e, @NotNull RootModelImpl m) throws InvalidDataException {
        this(ContentEntryImpl.getUrlFrom(e), m);
        this.initSourceFolders(e);
        this.initExcludeFolders(e);
    }

    private static String getUrlFrom(@NotNull Element e) throws InvalidDataException {
        LOG.assertTrue(ELEMENT_NAME.equals(e.getName()));
        String url = e.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    private void initSourceFolders(@NotNull Element e) throws InvalidDataException {
        for (Element child : e.getChildren("sourceFolder")) {
            this.addSourceFolder(new SourceFolderImpl(child, this));
        }
    }

    private void initExcludeFolders(@NotNull Element e) throws InvalidDataException {
        for (Element child : e.getChildren("excludeFolder")) {
            ExcludeFolderImpl excludeFolder = new ExcludeFolderImpl(child, this);
            this.addExcludeFolder((ExcludeFolder)excludeFolder);
        }
    }

    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @NotNull
    public String getUrl() {
        return this.myRoot.getUrl();
    }

    @NotNull
    public SourceFolder[] getSourceFolders() {
        return this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.getSourceFolders(Collections.singleton(rootType));
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        SmartList folders = new SmartList();
        for (SourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add((Object)folder);
        }
        return folders;
    }

    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        assert (!this.isDisposed());
        SourceFolder[] sourceFolders = this.getSourceFolders();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders.length);
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile file2 = sourceFolder.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        return this.myExcludeFolders.toArray(new ExcludeFolder[this.myExcludeFolders.size()]);
    }

    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (ExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                excluded.add(pointer.getUrl());
            }
        }
        return excluded;
    }

    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        assert (!this.isDisposed());
        ArrayList result2 = new ArrayList();
        for (ExcludeFolder excludeFolder : this.getExcludeFolders()) {
            ContainerUtil.addIfNotNull(result2, (Object)excludeFolder.getFile());
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : directoryIndexExcludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                ContainerUtil.addIfNotNull(result2, (Object)pointer.getFile());
            }
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        return this.addSourceFolder(file2, isTestSource, "");
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, @NotNull String packagePrefix) {
        JavaSourceRootType type2 = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        return this.addSourceFolder(file2, (JpsModuleSourceRootType)type2);
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type2, @NotNull P properties) {
        this.assertCanAddFolder(file2);
        return this.addSourceFolder(new SourceFolderImpl(file2, JpsElementFactory.getInstance().createModuleSourceRoot(file2.getUrl(), type2, properties), this));
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type2) {
        return this.addSourceFolder(file2, type2, (JpsElement)type2.createDefaultProperties());
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        return this.addSourceFolder(url, (JpsModuleSourceRootType)(isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE));
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type2) {
        return this.addSourceFolder(url, type2, (JpsElement)type2.createDefaultProperties());
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type2, @NotNull P properties) {
        this.assertFolderUnderMe(url);
        JpsModuleSourceRoot sourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, type2, properties);
        return this.addSourceFolder(new SourceFolderImpl(sourceRoot, this));
    }

    @NotNull
    private SourceFolder addSourceFolder(@NotNull SourceFolderImpl f) {
        this.mySourceFolders.add(f);
        Disposer.register((Disposable)this, (Disposable)f);
        return f;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(sourceFolder, this.mySourceFolders);
        this.doRemove(sourceFolder);
    }

    private void doRemove(SourceFolder sourceFolder) {
        this.mySourceFolders.remove(sourceFolder);
        Disposer.dispose((Disposable)((Disposable)sourceFolder));
    }

    public void clearSourceFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (SourceFolder folder : this.mySourceFolders) {
            Disposer.dispose((Disposable)((Disposable)folder));
        }
        this.mySourceFolders.clear();
    }

    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        assert (!this.isDisposed());
        this.assertCanAddFolder(file2);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(file2, this));
    }

    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        assert (!this.isDisposed());
        this.assertCanAddFolder(url);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(url, this));
    }

    private void assertCanAddFolder(@NotNull VirtualFile file2) {
        this.assertCanAddFolder(file2.getUrl());
    }

    private void assertCanAddFolder(@NotNull String url) {
        this.getRootModel().assertWritable();
        this.assertFolderUnderMe(url);
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(excludeFolder, this.myExcludeFolders);
        this.myExcludeFolders.remove(excludeFolder);
        Disposer.dispose((Disposable)((Disposable)excludeFolder));
    }

    public boolean removeExcludeFolder(@NotNull String url) {
        for (ExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            Disposer.dispose((Disposable)((Disposable)folder));
            return true;
        }
        return false;
    }

    public void clearExcludeFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)((Disposable)excludeFolder));
        }
        this.myExcludeFolders.clear();
    }

    private ExcludeFolder addExcludeFolder(ExcludeFolder f) {
        Disposer.register((Disposable)this, (Disposable)((Disposable)f));
        this.myExcludeFolders.add(f);
        return f;
    }

    private <T extends ContentFolder> void assertCanRemoveFrom(T f, @NotNull Set<T> ff) {
        this.getRootModel().assertWritable();
        LOG.assertTrue(ff.contains(f));
    }

    private void assertFolderUnderMe(@NotNull String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        String rootPath = VfsUtilCore.urlToPath((String)this.getUrl());
        if (!FileUtil.isAncestor((String)rootPath, (String)path, (boolean)false)) {
            LOG.error("The file '" + path + "' is not under content entry root '" + rootPath + "'");
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    @NotNull
    public ContentEntry cloneEntry(@NotNull RootModelImpl rootModel) {
        ContentFolder folder;
        assert (!this.isDisposed());
        ContentEntryImpl cloned = new ContentEntryImpl(this.myRoot.getUrl(), rootModel);
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)sourceFolder).cloneFolder(cloned);
            cloned.addSourceFolder((SourceFolderImpl)folder);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)excludeFolder).cloneFolder(cloned);
            cloned.addExcludeFolder((ExcludeFolder)folder);
        }
        return cloned;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        assert (!this.isDisposed());
        LOG.assertTrue(ELEMENT_NAME.equals(element.getName()));
        element.setAttribute(URL_ATTRIBUTE, this.myRoot.getUrl());
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof SourceFolderImpl)) continue;
            JpsModuleRootModelSerializer.saveSourceRoot((Element)element, (String)sourceFolder.getUrl(), (JpsTypedModuleSourceRoot)sourceFolder.getJpsElement().asTyped());
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ExcludeFolderImpl)) continue;
            Element subElement = new Element("excludeFolder");
            ((ExcludeFolderImpl)excludeFolder).writeExternal(subElement);
            element.addContent(subElement);
        }
    }

    @Override
    public int compareTo(@NotNull ContentEntryImpl other) {
        int i = this.getUrl().compareTo(other.getUrl());
        if (i != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare((Object[])this.getSourceFolders(), (Object[])other.getSourceFolders());
        if (i != 0) {
            return i;
        }
        return ArrayUtil.lexicographicCompare((Object[])this.getExcludeFolders(), (Object[])other.getExcludeFolders());
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

