/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ExcludeCompilerOutputPolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;

    public ExcludeCompilerOutputPolicy(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeRootsForProject() {
        VirtualFile outputPath = CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutput();
        if (outputPath != null) {
            return new VirtualFile[]{outputPath};
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        ArrayList result2 = new ArrayList();
        CompilerModuleExtension extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        if (extension.isCompilerOutputPathInherited()) {
            ContainerUtil.addIfNotNull(result2, (Object)CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutputPointer());
        } else {
            if (!extension.isExcludeOutput()) {
                return VirtualFilePointer.EMPTY_ARRAY;
            }
            ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputPointer());
            ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputForTestsPointer());
        }
        return result2.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : result2.toArray(new VirtualFilePointer[result2.size()]);
    }
}

