/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(@NotNull Project project2) {
        FilePropertyPusher[] extensions;
        PushedFilePropertiesUpdater instance = PushedFilePropertiesUpdater.getInstance((Project)project2);
        for (FilePropertyPusher pusher : extensions = (FilePropertyPusher[])EP_NAME.getExtensions()) {
            if (!(pusher instanceof JavaLanguageLevelPusher)) continue;
            instance.pushAll(new FilePropertyPusher[]{pusher});
        }
    }

    public void initExtra(@NotNull Project project2, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        return LanguageLevel.KEY;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        return LanguageLevel.HIGHEST;
    }

    public LanguageLevel getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        return null;
    }

    public LanguageLevel getImmediateValue(@NotNull Module module2) {
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module2);
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        return ProjectFileIndex.SERVICE.getInstance((Project)project2).isInSourceContent(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project2).filePropertiesChanged(child);
        }
    }

    private static boolean isJavaLike(FileType type2) {
        return type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public void afterRootsChanged(@NotNull Project project2) {
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message2, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file2) {
        return null;
    }
}

