/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LanguageLevelUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "module-language-level";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create(GROUP_ID, 100.0);
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        HashSet languageLevels = new HashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            LanguageLevelModuleExtensionImpl instance = LanguageLevelModuleExtensionImpl.getInstance((Module)module2);
            LanguageLevel languageLevel2 = instance.getLanguageLevel();
            if (languageLevel2 != null) {
                languageLevels.add(languageLevel2.toString());
                continue;
            }
            languageLevels.add(LanguageLevelProjectExtension.getInstance((Project)project2).getLanguageLevel().toString());
        }
        return ContainerUtil.map2Set((Collection)languageLevels, languageLevel -> new UsageDescriptor((String)languageLevel, 1));
    }
}

